/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.io.json.accumulator;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Map;
import java.util.stream.Stream;
import org.aksw.commons.util.stream.CollapseRunsSpec;
import org.aksw.commons.util.stream.StreamOperatorCollapseRuns;
import org.aksw.jenax.io.json.accumulator.AccContextRdf;
import org.aksw.jenax.io.json.accumulator.AccJson;
import org.aksw.jenax.ron.RdfElement;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Quad;

public class AccJsonDriver {
    protected AccJson currentState;
    protected Node currentSource;
    protected long sourcesSeen = 0L;
    protected boolean isSingle;

    protected AccJsonDriver(AccJson rootAcc, boolean isSingle) {
        Preconditions.checkArgument((rootAcc.getParent() == null ? 1 : 0) != 0, (Object)"Root accumulator must not have a parent");
        this.currentState = rootAcc;
        this.isSingle = isSingle;
    }

    public static AccJsonDriver of(AccJson rootAcc, boolean isSingle) {
        return new AccJsonDriver(rootAcc, isSingle);
    }

    public long getSourcesSeen() {
        return this.sourcesSeen;
    }

    public void accumulate(Quad input, AccContextRdf cxt) throws IOException {
        block5: {
            AccJson nextState;
            Node source = input.getGraph();
            Triple triple = input.asTriple();
            if (this.currentSource != null && !source.equals((Object)this.currentSource)) {
                this.endCurrentItem(cxt);
                this.currentSource = null;
            }
            boolean isNewSource = false;
            if (this.currentSource == null) {
                isNewSource = true;
                ++this.sourcesSeen;
                if (this.isSingle && this.sourcesSeen > 1L) {
                    throw new RuntimeException("Too many results. Maybe use @one(self: false)?");
                }
                this.currentSource = source;
                this.currentState.begin(this.currentSource, cxt, false);
                isNewSource = true;
            }
            if (isNewSource) break block5;
            while ((nextState = this.currentState.transition(triple, cxt)) == null) {
                this.currentState.end(cxt);
                AccJson parentAcc = this.currentState.getParent();
                if (parentAcc != null) {
                    this.currentState = parentAcc;
                    continue;
                }
                throw new RuntimeException("No acceptable transition for " + String.valueOf(triple));
            }
            this.currentState = nextState;
        }
    }

    public void begin(AccContextRdf cxt) throws IOException {
    }

    public void end(AccContextRdf cxt) throws IOException {
        this.endCurrentItem(cxt);
        this.currentSource = null;
    }

    public RdfElement getValue() {
        return this.currentState.getValue();
    }

    protected void endCurrentItem(AccContextRdf cxt) throws IOException {
        while (true) {
            AccJson parent;
            if (this.currentState.hasBegun()) {
                this.currentState.end(cxt);
            }
            if ((parent = this.currentState.getParent()) == null) break;
            this.currentState = parent;
        }
    }

    public Stream<Map.Entry<Node, RdfElement>> asStream(AccContextRdf cxt, Stream<Quad> quadStream) {
        Preconditions.checkArgument((!quadStream.isParallel() ? 1 : 0) != 0, (Object)"Json aggregation requires sequential stream");
        AccJsonDriver driver = this;
        CollapseRunsSpec spec = CollapseRunsSpec.create(Quad::getGraph, (accNum, collapseKey) -> driver, (acc, quad) -> {
            try {
                acc.accumulate((Quad)quad, cxt);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        Stream<Map.Entry<Node, RdfElement>> result = StreamOperatorCollapseRuns.create((CollapseRunsSpec)spec).transform(quadStream).map(entry -> {
            AccJsonDriver tmp = (AccJsonDriver)entry.getValue();
            try {
                tmp.end(cxt);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return Map.entry((Node)entry.getKey(), tmp.getValue());
        });
        return result;
    }
}

