/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.io.json.accumulator;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.aksw.jenax.io.json.accumulator.AccJsonEdge;
import org.aksw.jenax.io.json.accumulator.AccJsonFragmentBody;
import org.aksw.jenax.io.json.accumulator.AccJsonNode;
import org.aksw.jenax.io.json.accumulator.AggJsonEdge;
import org.aksw.jenax.io.json.accumulator.AggJsonNode;
import org.apache.jena.graph.Node;

public class AggJsonFragmentBody
implements AggJsonNode {
    protected LinkedHashMap<Node, AggJsonEdge> propertyAggregators = new LinkedHashMap();

    public static AggJsonFragmentBody of(AggJsonEdge ... edgeAggregators) {
        AggJsonFragmentBody result = new AggJsonFragmentBody();
        for (AggJsonEdge agg : edgeAggregators) {
            result.addPropertyAggregator(agg);
        }
        return result;
    }

    public HashMap<Node, AggJsonEdge> getPropertyAggregators() {
        return this.propertyAggregators;
    }

    public void addPropertyAggregator(AggJsonEdge propertyAggregator) {
        Node matchFieldId = propertyAggregator.getMatchFieldId();
        this.propertyAggregators.put(matchFieldId, propertyAggregator);
    }

    @Override
    public AccJsonNode newAccumulator() {
        int n = this.propertyAggregators.size();
        HashMap<Node, Integer> fieldIdToIndex = new HashMap<Node, Integer>();
        AccJsonEdge[] edgeAccs = new AccJsonEdge[n];
        int fieldIndex = 0;
        for (Map.Entry<Node, AggJsonEdge> e : this.propertyAggregators.entrySet()) {
            Node fieldId = e.getKey();
            AggJsonEdge agg = e.getValue();
            AccJsonEdge acc = agg.newAccumulator();
            fieldIdToIndex.put(fieldId, fieldIndex);
            edgeAccs[fieldIndex] = acc;
            ++fieldIndex;
        }
        AccJsonFragmentBody result = AccJsonFragmentBody.of(fieldIdToIndex, edgeAccs);
        return result;
    }
}

