/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.io.rdf.json;

import java.math.BigDecimal;
import java.util.function.Function;
import org.apache.jena.graph.Node;

public interface JsonProvider {
    public Object newObject();

    public boolean isObject(Object var1);

    public Node getObjectId(Object var1);

    public void setProperty(Object var1, String var2, Object var3);

    public Object getProperty(Object var1, String var2);

    public void removeProperty(Object var1, String var2);

    default public Object computePropertyIfAbsent(Object obj, String p, Function<String, Object> fn) {
        Object result = this.getProperty(obj, p);
        if (result == null) {
            result = fn.apply(p);
            this.ensureValidJson(result);
            this.setProperty(obj, p, result);
        }
        return result;
    }

    default public Object getOrCreateObject(Object parent, String p) {
        return this.computePropertyIfAbsent(parent, p, k -> this.newObject());
    }

    public void ensureValidJson(Object var1);

    public Object newArray();

    public boolean isArray(Object var1);

    public void addElement(Object var1, Object var2);

    public void setElement(Object var1, int var2, Object var3);

    public void removeElement(Object var1, int var2);

    public Object newLiteral(String var1);

    public Object newLiteral(boolean var1);

    public Object newLiteral(long var1);

    public Object newLiteral(double var1);

    public Object newLiteral(BigDecimal var1);

    public boolean isLiteral(Object var1);

    public Node getLiteral(Object var1);

    public Object newNull();

    public boolean isNull(Object var1);
}

