/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.json;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.PrintStream;
import org.aksw.jenax.arq.json.RdfJsonUtils;
import org.aksw.jenax.stmt.resultset.SPARQLResultSink;
import org.apache.jena.query.ResultSet;
import org.apache.jena.sparql.core.Quad;

public class SPARQLResultVisitorSelectJsonOutput
implements SPARQLResultSink {
    protected boolean flat = false;
    protected JsonArray arr;
    protected int maxDepth = 3;
    protected Gson gson;
    protected PrintStream out;
    protected PrintStream err;

    public SPARQLResultVisitorSelectJsonOutput() {
        this(null, null, null, null);
    }

    public SPARQLResultVisitorSelectJsonOutput(Gson gson) {
        this(null, null, null, gson);
    }

    public SPARQLResultVisitorSelectJsonOutput(JsonArray arr, Integer maxDepth, Boolean flat, Gson gson) {
        this(arr, maxDepth, flat, gson, null, null);
    }

    public SPARQLResultVisitorSelectJsonOutput(JsonArray arr, Integer maxDepth, Boolean flat, Gson gson, PrintStream out, PrintStream err) {
        this.arr = arr != null ? arr : new JsonArray();
        this.maxDepth = maxDepth != null ? maxDepth : 3;
        this.flat = flat != null ? flat : false;
        this.gson = gson != null ? gson : new Gson();
        this.out = out != null ? out : System.out;
        this.err = err != null ? err : System.err;
    }

    public void onResultSet(ResultSet value) {
        JsonArray json = RdfJsonUtils.toJson(value, this.maxDepth, this.flat);
        this.onJson((JsonElement)json);
    }

    public void onJson(JsonElement value) {
        this.arr.add(value);
    }

    public void onQuad(Quad value) {
        this.err.println(value);
    }

    public void close() throws Exception {
        JsonObject tmp;
        Object object = tmp = this.arr.size() == 0 ? new JsonObject() : this.arr.get(this.arr.size() - 1);
        if (this.flat && tmp.isJsonArray() && tmp.getAsJsonArray().size() == 1) {
            tmp = tmp.getAsJsonArray().get(0);
        }
        String str = this.gson.toJson((JsonElement)tmp);
        this.out.println(str);
    }

    public void flush() {
        this.out.flush();
        this.err.flush();
    }

    public PrintStream getOut() {
        return this.out;
    }

    public PrintStream getErr() {
        return this.err;
    }
}

