/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.io.json.writer;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Function;
import org.aksw.jenax.io.json.gon.GonProvider;
import org.aksw.jenax.io.json.writer.ObjectNotationWriter;
import org.aksw.jenax.io.json.writer.ObjectNotationWriterUtils;

public class ObjectNotationWriterMapper<KI, KO, VI, VO>
implements ObjectNotationWriter<KI, VI> {
    protected ObjectNotationWriter<KO, VO> delegate;
    protected GonProvider<KO, VO> gonProvider;
    protected Function<? super KI, ? extends KO> keyMapper;
    protected Function<? super VI, ? extends Object> valueMapper;

    public ObjectNotationWriterMapper(ObjectNotationWriter<KO, VO> delegate, GonProvider<KO, VO> gonProvider, Function<? super KI, ? extends KO> keyMapper, Function<? super VI, ? extends Object> valueMapper) {
        this.delegate = Objects.requireNonNull(delegate);
        this.gonProvider = Objects.requireNonNull(gonProvider);
        this.keyMapper = Objects.requireNonNull(keyMapper);
        this.valueMapper = Objects.requireNonNull(valueMapper);
    }

    protected ObjectNotationWriter<KO, VO> getDelegate() {
        return this.delegate;
    }

    @Override
    public void flush() throws IOException {
        this.getDelegate().flush();
    }

    @Override
    public ObjectNotationWriter<KI, VI> beginArray() throws IOException {
        this.getDelegate().beginArray();
        return this;
    }

    @Override
    public ObjectNotationWriter<KI, VI> endArray() throws IOException {
        this.getDelegate().endArray();
        return this;
    }

    @Override
    public ObjectNotationWriter<KI, VI> beginObject() throws IOException {
        this.getDelegate().beginObject();
        return this;
    }

    @Override
    public ObjectNotationWriter<KI, VI> endObject() throws IOException {
        this.getDelegate().endObject();
        return this;
    }

    @Override
    public ObjectNotationWriter<KI, VI> name(KI key) throws IOException {
        KO outKey = this.keyMapper.apply(key);
        this.getDelegate().name(outKey);
        return this;
    }

    @Override
    public ObjectNotationWriter<KI, VI> value(VI value) throws IOException {
        Object outValue = this.valueMapper.apply(value);
        ObjectNotationWriterUtils.sendToWriter(this.delegate, this.gonProvider, outValue);
        return this;
    }

    @Override
    public ObjectNotationWriter<KI, VI> nullValue() throws IOException {
        this.getDelegate().nullValue();
        return this;
    }
}

