/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.json;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.parsers.wkt.WKTWriter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.geojson.GeoJsonWriter;

public class RdfJsonUtils {
    public static JsonElement toJson(RDFNode rdfNode, int maxDepth, boolean flat) {
        JsonElement result = RdfJsonUtils.toJson(rdfNode, 0, maxDepth, flat);
        return result;
    }

    public static JsonObject toJson(Resource rdfNode, int maxDepth, boolean flat) {
        JsonElement tmp = RdfJsonUtils.toJson((RDFNode)rdfNode, 0, maxDepth, flat);
        JsonObject result = tmp.getAsJsonObject();
        return result;
    }

    public static JsonArray toJson(Collection<? extends RDFNode> rdfNodes, int maxDepth, boolean flat) {
        JsonArray result = new JsonArray();
        for (RDFNode rDFNode : rdfNodes) {
            JsonElement jsonElement = RdfJsonUtils.toJson(rDFNode, maxDepth, flat);
            result.add(jsonElement);
        }
        return result;
    }

    public static JsonArray toJson(ResultSet rs, int maxDepth, boolean flat) {
        JsonArray result = new JsonArray();
        List vars = rs.getResultVars();
        while (rs.hasNext()) {
            QuerySolution qs = rs.next();
            JsonObject row = RdfJsonUtils.toJson(qs, maxDepth, flat);
            if (flat && vars.size() == 1) {
                result.add((JsonElement)((Map.Entry)row.entrySet().iterator().next()).getValue());
                continue;
            }
            result.add((JsonElement)row);
        }
        return result;
    }

    public static JsonObject toJson(QuerySolution qs, int maxDepth, boolean flat) {
        JsonObject row = new JsonObject();
        Iterator it = qs.varNames();
        while (it.hasNext()) {
            String varName = (String)it.next();
            RDFNode rdfNode = qs.get(varName);
            JsonElement jsonElement = RdfJsonUtils.toJson(rdfNode, maxDepth, flat);
            row.add(varName, jsonElement);
        }
        return row;
    }

    public static JsonElement toJson(RDFNode rdfNode, int depth, int maxDepth, boolean flat) {
        Graph g = rdfNode.getModel().getGraph();
        Node node = rdfNode.asNode();
        JsonElement result = RdfJsonUtils.toJson(g, node, depth, maxDepth, flat);
        return result;
    }

    public static JsonElement toJson(Graph graph, Node node, int depth, int maxDepth, boolean flat) {
        JsonNull result;
        if (depth >= maxDepth) {
            result = null;
        } else if (node == null) {
            result = JsonNull.INSTANCE;
        } else if (node.isLiteral()) {
            Object obj = node.getLiteralValue();
            if (obj instanceof String) {
                String value = (String)obj;
                result = new JsonPrimitive(value);
            } else if (obj instanceof Number) {
                Number value = (Number)obj;
                result = new JsonPrimitive(value);
            } else if (obj instanceof Boolean) {
                Boolean value = (Boolean)obj;
                result = new JsonPrimitive(value);
            } else if (obj instanceof GeometryWrapper) {
                String datatypeUri;
                GeometryWrapper w = (GeometryWrapper)obj;
                switch (datatypeUri = node.getLiteralDatatypeURI()) {
                    case "http://www.opengis.net/ont/geosparql#wktLiteral": {
                        result = new JsonPrimitive(WKTWriter.write((GeometryWrapper)w));
                        break;
                    }
                    case "http://www.opengis.net/ont/geosparql#geoJSONLiteral": {
                        GeoJsonWriter geoJsonWriter = new GeoJsonWriter();
                        Geometry geom = w.getParsingGeometry();
                        String jsonString = geoJsonWriter.write(geom);
                        Gson gson = new Gson();
                        result = (JsonElement)gson.fromJson(jsonString, JsonObject.class);
                        break;
                    }
                    default: {
                        result = new JsonPrimitive(node.getLiteralLexicalForm());
                        break;
                    }
                }
            } else {
                String value = node.getLiteralLexicalForm();
                result = new JsonPrimitive(value);
            }
        } else if (!node.isLiteral()) {
            JsonObject tmp = new JsonObject();
            if (node.isURI()) {
                tmp.addProperty("id", node.getURI());
                tmp.addProperty("id_type", "uri");
            } else if (node.isBlank()) {
                tmp.addProperty("id", node.getBlankNodeLabel());
                tmp.addProperty("id_type", "bnode");
            }
            List stmts = graph.find(node, Node.ANY, Node.ANY).toList();
            Map pos = stmts.stream().collect(Collectors.groupingBy(Triple::getPredicate, Collectors.mapping(Triple::getObject, Collectors.toList())));
            for (Map.Entry e : pos.entrySet()) {
                JsonArray arr = new JsonArray();
                Node p = e.getKey();
                String k = p.getLocalName();
                for (Node o : e.getValue()) {
                    JsonElement v = RdfJsonUtils.toJson(graph, o, depth + 1, maxDepth, flat);
                    if (v == null) continue;
                    arr.add(v);
                }
                if (arr.size() <= 0) continue;
                if (flat && arr.size() == 1) {
                    tmp.add(k, arr.get(0));
                    continue;
                }
                tmp.add(k, (JsonElement)arr);
            }
            result = tmp;
        } else {
            throw new RuntimeException("Unknown node type: " + String.valueOf(node));
        }
        return result;
    }
}

