/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.io.json.writer;

import java.util.Objects;
import java.util.Stack;
import org.aksw.jenax.io.json.gon.GonProvider;
import org.aksw.jenax.io.json.writer.ObjectNotationWriter;

public class ObjectNotationWriterViaGon<K, V>
implements ObjectNotationWriter<K, V> {
    protected GonProvider<K, V> provider;
    protected Stack<Object> stack = new Stack();
    protected K pendingKey;
    protected Object product;

    protected ObjectNotationWriterViaGon(GonProvider<K, V> provider) {
        this.provider = Objects.requireNonNull(provider);
    }

    public static <K, V> ObjectNotationWriterViaGon<K, V> of(GonProvider<K, V> provider) {
        return new ObjectNotationWriterViaGon<K, V>(provider);
    }

    public Object getProduct() {
        return this.product;
    }

    @Override
    public void flush() {
    }

    protected void put(Object elt) {
        if (this.pendingKey != null) {
            Object current = this.stack.peek();
            this.provider.setProperty(current, this.pendingKey, elt);
            this.pendingKey = null;
        } else if (this.stack.isEmpty()) {
            this.product = elt;
        } else {
            Object current = this.stack.peek();
            if (this.provider.isArray(current)) {
                this.provider.addElement(current, elt);
            } else {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    public ObjectNotationWriter<K, V> beginArray() {
        Object elt = this.provider.newArray();
        this.put(elt);
        this.stack.add(elt);
        return this;
    }

    @Override
    public ObjectNotationWriter<K, V> endArray() {
        Object elt = this.stack.peek();
        if (!this.provider.isArray(elt)) {
            throw new IllegalStateException();
        }
        this.stack.pop();
        return this;
    }

    @Override
    public ObjectNotationWriter<K, V> beginObject() {
        Object elt = this.provider.newObject();
        this.put(elt);
        this.stack.add(elt);
        return this;
    }

    @Override
    public ObjectNotationWriter<K, V> endObject() {
        Object elt = this.stack.peek();
        if (!this.provider.isObject(elt)) {
            throw new IllegalStateException();
        }
        this.stack.pop();
        return this;
    }

    @Override
    public ObjectNotationWriter<K, V> name(K key) {
        Object elt = this.stack.peek();
        if (!this.provider.isObject(elt)) {
            throw new IllegalStateException("Element under construction is not an object.");
        }
        if (this.pendingKey != null) {
            throw new IllegalStateException("A pending name has already been set.");
        }
        this.pendingKey = key;
        return this;
    }

    @Override
    public ObjectNotationWriter<K, V> value(V value) {
        Object elt = this.provider.newLiteral(value);
        this.put(elt);
        return this;
    }

    @Override
    public ObjectNotationWriter<K, V> nullValue() {
        Object nil = this.provider.newNull();
        this.put(nil);
        return this;
    }
}

