/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.io.json.accumulator;

import java.io.IOException;
import org.aksw.commons.path.json.PathJson;
import org.aksw.jenax.io.json.accumulator.AccContextRdf;
import org.aksw.jenax.io.json.accumulator.AccJson;
import org.aksw.jenax.io.json.accumulator.AccJsonBase;
import org.aksw.jenax.io.json.accumulator.AccJsonNode;
import org.aksw.jenax.io.json.writer.RdfObjectNotationWriter;
import org.aksw.jenax.ron.RdfElement;
import org.aksw.jenax.ron.RdfLiteralImpl;
import org.aksw.jenax.ron.RdfNull;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;

public class AccJsonLiteral
extends AccJsonBase
implements AccJsonNode {
    @Override
    public PathJson getPath() {
        return (PathJson)(this.parent != null ? this.parent.getPath() : PathJson.newRelativePath((PathJson.Step[])new PathJson.Step[0])).resolve((Object)PathJson.Step.of((String)"literal"));
    }

    @Override
    public void begin(Node node, AccContextRdf context, boolean skipOutput) throws IOException {
        super.begin(node, context, skipOutput);
        this.value = new RdfLiteralImpl(node);
    }

    @Override
    public AccJson transition(Triple edge, AccContextRdf context) {
        this.ensureBegun();
        return null;
    }

    @Override
    public void end(AccContextRdf context) throws IOException {
        this.ensureBegun();
        if (!this.skipOutput) {
            RdfElement effectiveValue;
            RdfElement rdfElement = effectiveValue = this.value == null ? new RdfNull() : this.value;
            if (context.isSerialize()) {
                RdfObjectNotationWriter writer = context.getJsonWriter();
                if (this.value == null) {
                    writer.nullValue();
                } else {
                    writer.value(this.value.getAsLiteral().getInternalId());
                }
            }
            if (context.isMaterialize() && this.parent != null) {
                this.parent.acceptContribution(effectiveValue, context);
            }
        }
        super.end(context);
    }

    public String toString() {
        return "AccJsonNodeLiteral(source: " + String.valueOf(this.currentSourceNode) + ")";
    }

    @Override
    public void acceptContribution(RdfElement value, AccContextRdf context) {
        throw new UnsupportedOperationException("Literals cannot expect json elemnts as contributions");
    }
}

