/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.io.hdt;

import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.aksw.jena_sparql_api.io.hdt.JenaPluginHdt;
import org.apache.commons.io.output.WriterOutputStream;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.writer.WriterGraphRIOTBase;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.rdfhdt.hdt.hdt.HDT;
import org.rdfhdt.hdt.hdt.HDTManager;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.options.HDTSpecification;
import org.rdfhdt.hdt.triples.TripleString;

public class WriterGraphRIOT_HDT
extends WriterGraphRIOTBase {
    public Lang getLang() {
        return JenaPluginHdt.LANG_HDT;
    }

    public void write(Writer writer, Graph graph, PrefixMap prefixMap, String baseURI, Context context) {
        WriterOutputStream out = new WriterOutputStream(writer, StandardCharsets.UTF_8);
        this.write((OutputStream)out, graph, prefixMap, baseURI, context);
    }

    public static String encode(Node node, String baseURI, PrefixMap prefixMap) {
        String result = node.isURI() ? node.getURI() : NodeFmtLib.strNodesTTL((Node[])new Node[]{node});
        return result;
    }

    public static TripleString encode(Triple triple, String baseURI, PrefixMap prefixMap) {
        TripleString result = new TripleString((CharSequence)WriterGraphRIOT_HDT.encode(triple.getSubject(), baseURI, prefixMap), (CharSequence)WriterGraphRIOT_HDT.encode(triple.getPredicate(), baseURI, prefixMap), (CharSequence)WriterGraphRIOT_HDT.encode(triple.getObject(), baseURI, prefixMap));
        return result;
    }

    public void write(OutputStream out, Graph graph, PrefixMap prefixMap, String rawBaseURI, Context context) {
        String baseURI = rawBaseURI == null ? "http://www.example.org/" : rawBaseURI;
        try (ExtendedIterator it = graph.find().mapWith(t -> WriterGraphRIOT_HDT.encode(t, baseURI, prefixMap));){
            HDT hdt = HDTManager.generateHDT((Iterator)it, (String)baseURI, (HDTOptions)new HDTSpecification(), null);
            hdt.saveToHDT(out, null);
        }
    }
}

