/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.io.hdt;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.ReaderRIOT;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.rdfhdt.hdt.hdt.HDT;
import org.rdfhdt.hdt.hdt.HDTManager;
import org.rdfhdt.hdtjena.HDTGraph;

public class ReaderRIOT_HDT
implements ReaderRIOT {
    public void read(Reader reader, String baseURI, ContentType ct, StreamRDF output, Context context) {
        ReaderInputStream in = new ReaderInputStream(reader, StandardCharsets.UTF_8);
        this.read((InputStream)in, baseURI, ct, output, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(InputStream in, String baseURI, ContentType ct, StreamRDF output, Context context) {
        HDT hdt = null;
        try {
            hdt = HDTManager.loadHDT((InputStream)new BufferedInputStream(in));
            try (HDTGraph graph = null;){
                graph = new HDTGraph(hdt);
                ExtendedIterator it = graph.find();
                try {
                    while (it.hasNext()) {
                        Triple t = (Triple)it.next();
                        output.triple(t);
                    }
                }
                finally {
                    it.close();
                    output.finish();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (hdt != null) {
                    hdt.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

