/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.io.hdt;

import java.util.Objects;
import org.aksw.jena_sparql_api.io.hdt.ReaderRIOT_HDT;
import org.aksw.jena_sparql_api.io.hdt.WriterGraphRIOT_HDT;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.LangBuilder;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFFormatVariant;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParserRegistry;
import org.apache.jena.riot.RDFWriterRegistry;
import org.apache.jena.riot.ReaderRIOT;
import org.apache.jena.riot.ReaderRIOTFactory;
import org.apache.jena.riot.WriterGraphRIOT;
import org.apache.jena.riot.WriterGraphRIOTFactory;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.sys.JenaSubsystemLifecycle;

public class JenaPluginHdt
implements JenaSubsystemLifecycle {
    public static final Lang LANG_HDT = LangBuilder.create((String)"hdt", (String)"application/x-hdt").addFileExtensions(new String[]{"hdt"}).build();
    public static final RDFFormat FORMAT_HDT = new RDFFormat(LANG_HDT, new RDFFormatVariant("default"));

    public void start() {
        JenaPluginHdt.init();
    }

    public void stop() {
    }

    public static void init() {
        if (RDFLanguages.fileExtToLang((String)"hdt") != null) {
            return;
        }
        ReaderRIOTFactory readerFactory = new ReaderRIOTFactory(){

            public ReaderRIOT create(Lang language, ParserProfile profile) {
                if (!LANG_HDT.equals((Object)language)) {
                    throw new InternalErrorException("Attempt to parse " + String.valueOf(language) + " as HDT");
                }
                ReaderRIOT_HDT r = new ReaderRIOT_HDT();
                return r;
            }
        };
        WriterGraphRIOTFactory writerFactory = new WriterGraphRIOTFactory(){

            public WriterGraphRIOT create(RDFFormat serialization) {
                WriterGraphRIOT_HDT result = Objects.equals(FORMAT_HDT, serialization) ? new WriterGraphRIOT_HDT() : null;
                return result;
            }
        };
        RDFLanguages.register((Lang)LANG_HDT);
        RDFWriterRegistry.register((RDFFormat)FORMAT_HDT, (WriterGraphRIOTFactory)writerFactory);
        RDFWriterRegistry.register((Lang)LANG_HDT, (RDFFormat)FORMAT_HDT);
        RDFParserRegistry.registerLangTriples((Lang)LANG_HDT, (ReaderRIOTFactory)readerFactory);
    }
}

