/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.io.hdt;

import java.io.IOException;
import java.util.Iterator;
import org.aksw.jenax.arq.util.io.NTripleUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.GraphBase;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.engine.main.OpExecutorFactory;
import org.apache.jena.sparql.engine.main.QC;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderTransformation;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;
import org.rdfhdt.hdt.exceptions.NotFoundException;
import org.rdfhdt.hdt.hdt.HDT;
import org.rdfhdt.hdt.triples.IteratorTripleString;
import org.rdfhdt.hdtjena.HDTCapabilities;
import org.rdfhdt.hdtjena.HDTStatistics;
import org.rdfhdt.hdtjena.NodeDictionary;
import org.rdfhdt.hdtjena.solver.HDTQueryEngine;
import org.rdfhdt.hdtjena.solver.OpExecutorHDT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HDTHeaderGraph
extends GraphBase {
    private static final Logger log = LoggerFactory.getLogger(HDTHeaderGraph.class);
    private static final HDTCapabilities capabilities = new HDTCapabilities();
    private HDT hdt;
    private ReorderTransformation reorderTransform;
    private HDTStatistics hdtStatistics;
    private long numSearches;
    private boolean closeAfter;

    public HDTHeaderGraph(HDT hdt) {
        this(hdt, false);
    }

    public HDTHeaderGraph(HDT hdt, boolean close) {
        this.hdt = hdt;
        this.closeAfter = close;
    }

    public HDT getHDT() {
        return this.hdt;
    }

    protected ExtendedIterator<Triple> graphBaseFind(Triple jenaTriple) {
        IteratorTripleString hdtIterator;
        String s = NodeDictionary.nodeToStr((Node)jenaTriple.getMatchSubject());
        String p = NodeDictionary.nodeToStr((Node)jenaTriple.getMatchPredicate());
        String o = NodeDictionary.nodeToStr((Node)jenaTriple.getMatchObject());
        try {
            hdtIterator = this.hdt.getHeader().search((CharSequence)s, (CharSequence)p, (CharSequence)o);
        }
        catch (NotFoundException e1) {
            throw new RuntimeException(e1);
        }
        ExtendedIterator result = WrappedIterator.create((Iterator)hdtIterator).mapWith(t -> {
            String r;
            try {
                r = t.asNtriple().toString();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return r;
        }).mapWith(NTripleUtils::parseNTriplesString);
        return result;
    }

    public long getNumSearches() {
        return this.numSearches;
    }

    public ReorderTransformation getReorderTransform() {
        return this.reorderTransform;
    }

    protected int graphBaseSize() {
        return this.hdt.getHeader().getNumberOfElements();
    }

    public void close() {
        super.close();
        if (this.closeAfter) {
            try {
                this.hdt.close();
            }
            catch (IOException e) {
                log.error("Unexpected exception.", (Throwable)e);
            }
        }
    }

    static {
        QC.setFactory((Context)ARQ.getContext(), (OpExecutorFactory)OpExecutorHDT.opExecFactoryHDT);
        HDTQueryEngine.register();
    }
}

