/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.rx.entity.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.aksw.jena_sparql_api.rx.entity.model.EntityTemplateImpl;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.syntax.Template;

public interface EntityTemplate {
    public EntityTemplate cloneTemplate();

    public Template getTemplate();

    public void setTemplate(Template var1);

    public List<Node> getEntityNodes();

    public Map<Node, ExprList> getBnodeIdMapping();

    public EntityTemplate applyNodeTransform(NodeTransform var1);

    public static EntityTemplate merge(EntityTemplate ... templates) {
        LinkedHashSet triples = new LinkedHashSet();
        LinkedHashSet<Node> entityNodes = new LinkedHashSet<Node>();
        LinkedHashMap<Node, ExprList> bnodeIdMapping = new LinkedHashMap<Node, ExprList>();
        for (EntityTemplate template : templates) {
            triples.addAll(template.getTemplate().getBGP().getList());
            entityNodes.addAll(template.getEntityNodes());
            bnodeIdMapping.putAll(template.getBnodeIdMapping());
        }
        EntityTemplateImpl result = new EntityTemplateImpl(new ArrayList<Node>(entityNodes), new Template(BasicPattern.wrap(new ArrayList(triples))), bnodeIdMapping);
        return result;
    }
}

