/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.rx.entity.engine;

import io.reactivex.rxjava3.core.Flowable;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.aksw.jena_sparql_api.rx.entity.engine.EntityQueryRx;
import org.aksw.jena_sparql_api.rx.entity.model.EntityQueryBasic;
import org.aksw.jena_sparql_api.rx.entity.model.EntityQueryImpl;
import org.aksw.jena_sparql_api.rx.entity.model.ExprListEval;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactoryQuery;
import org.apache.jena.graph.Graph;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdfconnection.SparqlQueryConnection;
import org.apache.jena.sparql.graph.GraphFactory;

public class EntityQueryRxBuilder {
    protected QueryExecutionFactoryQuery queryExecutionFactory = null;
    protected EntityQueryBasic basicEntityQuery = null;
    protected Supplier<Graph> graphSupplier = null;
    protected ExprListEval exprListEval = null;

    public static EntityQueryRxBuilder create() {
        return new EntityQueryRxBuilder();
    }

    public EntityQueryRxBuilder setQueryExecutionFactory(SparqlQueryConnection conn) {
        this.queryExecutionFactory = arg_0 -> ((SparqlQueryConnection)conn).query(arg_0);
        return this;
    }

    public EntityQueryRxBuilder setQueryExecutionFactory(QueryExecutionFactoryQuery queryExecutionFactory) {
        this.queryExecutionFactory = queryExecutionFactory;
        return this;
    }

    public EntityQueryRxBuilder setQueryExecutionFactory(Function<? super Query, ? extends QueryExecution> queryExecutionFactory) {
        this.queryExecutionFactory = queryExecutionFactory::apply;
        return this;
    }

    public EntityQueryRxBuilder setQuery(EntityQueryImpl query) {
        this.basicEntityQuery = EntityQueryRx.assembleEntityAndAttributeParts(query);
        return this;
    }

    public EntityQueryRxBuilder Query(EntityQueryBasic query) {
        this.basicEntityQuery = query;
        return this;
    }

    public EntityQueryRxBuilder setGraphSupplier(Supplier<Graph> graphSupplier) {
        this.graphSupplier = graphSupplier;
        return this;
    }

    public EntityQueryRxBuilder setExprListEval(ExprListEval exprListEval) {
        this.exprListEval = exprListEval;
        return this;
    }

    public Flowable<RDFNode> build() {
        Objects.requireNonNull(this.queryExecutionFactory, "Query execution factory not set");
        Objects.requireNonNull(this.basicEntityQuery, "Entity query not set");
        return EntityQueryRx.execConstructEntities(this.queryExecutionFactory, this.basicEntityQuery, Optional.ofNullable(this.graphSupplier).orElse(GraphFactory::createDefaultGraph), Optional.ofNullable(this.exprListEval).orElse(EntityQueryRx::defaultEvalToNode));
    }
}

