/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.rx.entity.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.aksw.jena_sparql_api.rx.entity.model.EntityTemplate;
import org.aksw.jena_sparql_api.rx.entity.model.EntityTemplateImpl;
import org.apache.jena.query.Query;
import org.apache.jena.query.SortCondition;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.syntax.Template;

public class EntityBaseQuery
implements Cloneable {
    protected Query standardQuery;
    protected EntityTemplate entityTemplate;
    protected List<Var> partitionVars;
    protected List<SortCondition> partitionOrderBy;

    public EntityBaseQuery(List<Var> partitionVars, EntityTemplate entityTemplate, Query standardQuery) {
        this(partitionVars, entityTemplate, standardQuery, new ArrayList<SortCondition>());
    }

    public EntityBaseQuery(List<Var> partitionVars, EntityTemplate entityTemplate, Query standardQuery, List<SortCondition> partitionOrderBy) {
        this.standardQuery = standardQuery;
        this.entityTemplate = entityTemplate;
        this.partitionVars = partitionVars;
        this.partitionOrderBy = partitionOrderBy;
    }

    public EntityBaseQuery cloneQuery() {
        return new EntityBaseQuery(new ArrayList<Var>(this.partitionVars), this.entityTemplate.cloneTemplate(), this.standardQuery.cloneQuery(), new ArrayList<SortCondition>(this.partitionOrderBy));
    }

    public Query getStandardQuery() {
        return this.standardQuery;
    }

    public EntityTemplate getEntityTemplate() {
        return this.entityTemplate;
    }

    public void setEntityTemplate(EntityTemplate entityTemplate) {
        this.entityTemplate = entityTemplate;
    }

    public void setStandardQuery(Query standardQuery) {
        this.standardQuery = standardQuery;
    }

    public List<Var> getPartitionVars() {
        return this.partitionVars;
    }

    public void setPartitionVars(List<Var> partitionVars) {
        this.partitionVars = partitionVars;
    }

    public List<SortCondition> getPartitionOrderBy() {
        return this.partitionOrderBy;
    }

    public String toString() {
        String result = "ENTITY " + String.valueOf(this.partitionVars) + "\nCONSTRUCT " + String.valueOf(this.entityTemplate) + "\nWHERE " + String.valueOf(this.standardQuery) + "\nORDER ENTITIES BY " + String.valueOf(this.partitionOrderBy);
        return result;
    }

    public static EntityBaseQuery create(Var partitionAndEntityVar, Query standardQuery) {
        Query partitionSelect = standardQuery.cloneQuery();
        partitionSelect.setQuerySelectType();
        partitionSelect.setQueryResultStar(true);
        List<Var> partitionVars = Collections.singletonList(partitionAndEntityVar);
        List<Var> entityNodes = Collections.singletonList(partitionAndEntityVar);
        Template template = standardQuery.getConstructTemplate();
        if (template == null) {
            template = new Template(new BasicPattern());
        }
        EntityTemplateImpl et = new EntityTemplateImpl(entityNodes, template);
        EntityBaseQuery result = new EntityBaseQuery(partitionVars, et, partitionSelect);
        return result;
    }
}

