/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.rx.entity.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.aksw.jena_sparql_api.rx.entity.model.EntityTemplate;
import org.aksw.jena_sparql_api.rx.entity.model.EntityTemplateImpl;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.graph.NodeTransformLib;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementGroup;

public class EntityGraphFragment {
    protected List<Var> partitionVars;
    protected EntityTemplate entityTemplate;
    protected Element element;

    public EntityGraphFragment() {
        this(new ArrayList<Var>(), new EntityTemplateImpl(), null);
    }

    public EntityGraphFragment(List<Var> partitionVars, EntityTemplate entityTemplate, Element element) {
        this.partitionVars = partitionVars;
        this.entityTemplate = entityTemplate;
        this.element = element;
    }

    public static EntityGraphFragment empty(List<Var> partitionVars) {
        return new EntityGraphFragment(partitionVars, new EntityTemplateImpl(), (Element)new ElementGroup());
    }

    public static EntityGraphFragment fromQuery(Var entityVar, Query query) {
        return EntityGraphFragment.fromQuery(Arrays.asList(entityVar), Arrays.asList(entityVar), query);
    }

    public static EntityGraphFragment fromQuery(List<Var> partitionVars, List<Node> entityNodes, Query query) {
        EntityGraphFragment result = new EntityGraphFragment(partitionVars, new EntityTemplateImpl(entityNodes, query.getConstructTemplate()), query.getQueryPattern());
        return result;
    }

    public EntityTemplate getEntityTemplate() {
        return this.entityTemplate;
    }

    public void setEntityTemplate(EntityTemplate entityTemplate) {
        this.entityTemplate = entityTemplate;
    }

    public Element getElement() {
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public List<Var> getPartitionVars() {
        return this.partitionVars;
    }

    public void setPartitionVars(List<Var> entityVars) {
        this.partitionVars = entityVars;
    }

    public EntityGraphFragment applyNodeTransform(NodeTransform nodeTransform) {
        EntityGraphFragment result = new EntityGraphFragment(NodeTransformLib.transformVars((NodeTransform)nodeTransform, this.partitionVars), this.entityTemplate.applyNodeTransform(nodeTransform), ElementUtils.applyNodeTransform((Element)this.element, (NodeTransform)nodeTransform));
        return result;
    }

    public String toString() {
        String result = "ENTITY " + String.valueOf(this.partitionVars) + "\nCONSTRUCT " + String.valueOf(this.entityTemplate) + "\nWHERE " + String.valueOf(this.element);
        return result;
    }
}

