/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.rx.entity.engine;

import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableOperator;
import io.reactivex.rxjava3.core.FlowableTransformer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.aksw.commons.collections.SetUtils;
import org.aksw.commons.collections.generator.Generator;
import org.aksw.commons.collector.domain.Accumulator;
import org.aksw.commons.collector.domain.Aggregator;
import org.aksw.commons.rx.op.FlowableOperatorCollapseRuns;
import org.aksw.commons.util.stream.CollapseRunsSpec;
import org.aksw.jena_sparql_api.rx.AggObjectGraph;
import org.aksw.jena_sparql_api.rx.ExprTransformAllocAggregate;
import org.aksw.jena_sparql_api.rx.entity.model.EntityBaseQuery;
import org.aksw.jena_sparql_api.rx.entity.model.EntityGraphFragment;
import org.aksw.jena_sparql_api.rx.entity.model.EntityQueryBasic;
import org.aksw.jena_sparql_api.rx.entity.model.EntityQueryImpl;
import org.aksw.jena_sparql_api.rx.entity.model.EntityTemplate;
import org.aksw.jena_sparql_api.rx.entity.model.EntityTemplateImpl;
import org.aksw.jena_sparql_api.rx.entity.model.ExprListEval;
import org.aksw.jena_sparql_api.rx.entity.model.GraphPartitionJoin;
import org.aksw.jena_sparql_api.rx.entity.model.GraphPartitionWithEntities;
import org.aksw.jenax.arq.aggregation.AggCollection;
import org.aksw.jenax.arq.util.node.NodeTransformRenameMap;
import org.aksw.jenax.arq.util.quad.QuadPatternUtils;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.arq.util.syntax.QueryUtils;
import org.aksw.jenax.arq.util.syntax.VarExprListUtils;
import org.aksw.jenax.arq.util.var.VarGeneratorBlacklist;
import org.aksw.jenax.arq.util.var.VarGeneratorImpl2;
import org.aksw.jenax.arq.util.var.VarUtils;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactoryQuery;
import org.aksw.jenax.sparql.query.rx.SparqlRx;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.SortCondition;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.algebra.TableFactory;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprTransformer;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.ExprVars;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementOptional;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.sparql.syntax.PatternVars;
import org.apache.jena.sparql.syntax.Template;
import org.apache.jena.sparql.util.ExprUtils;
import org.apache.jena.sparql.util.ModelUtils;
import org.apache.jena.util.iterator.ExtendedIterator;

public class EntityQueryRx {
    public static Flowable<Quad> execConstructEntitiesNg(QueryExecutionFactoryQuery conn, EntityQueryImpl query) {
        return EntityQueryRx.execConstructEntitiesNg(conn, query, GraphFactory::createDefaultGraph);
    }

    public static Flowable<Quad> execConstructEntitiesNg(QueryExecutionFactoryQuery conn, EntityQueryImpl query, Supplier<Graph> graphSupplier) {
        return EntityQueryRx.execConstructEntitiesNg(conn, query, GraphFactory::createDefaultGraph, EntityQueryRx::defaultEvalToNode);
    }

    public static Flowable<Quad> execConstructEntitiesNg(QueryExecutionFactoryQuery conn, EntityQueryImpl queryEx, Supplier<Graph> graphSupplier, ExprListEval exprListEval) {
        EntityQueryBasic basicEntityQuery = EntityQueryRx.assembleEntityAndAttributeParts(queryEx);
        return EntityQueryRx.execConstructEntitiesNg(conn, basicEntityQuery, graphSupplier, exprListEval);
    }

    public static Flowable<RDFNode> execConstructRooted(QueryExecutionFactoryQuery conn, EntityQueryBasic query) {
        return EntityQueryRx.execConstructRooted(conn, query, GraphFactory::createDefaultGraph);
    }

    public static Flowable<RDFNode> execConstructRooted(QueryExecutionFactoryQuery conn, EntityQueryBasic query, Supplier<Graph> graphSupplier) {
        return EntityQueryRx.execConstructEntities(conn, query, GraphFactory::createDefaultGraph, EntityQueryRx::defaultEvalToNode);
    }

    public static EntityQueryImpl alignVariables(EntityQueryImpl query) {
        GraphPartitionJoin newJoin;
        NodeTransformRenameMap nodeTransform;
        Map varMap;
        List<Var> targetJoinVars;
        Set targetVars;
        EntityGraphFragment egm;
        EntityQueryImpl result = new EntityQueryImpl();
        result.setBaseQuery(query.getBaseQuery());
        Set sourceVars = QueryUtils.mentionedVars((Query)result.getBaseQuery().getStandardQuery());
        List<Var> sourceJoinVars = result.getBaseQuery().getPartitionVars();
        VarGeneratorImpl2 varGen = VarGeneratorImpl2.create();
        for (GraphPartitionJoin join : query.getMandatoryJoins()) {
            egm = join.getEntityGraphFragment();
            targetVars = ElementUtils.getVarsMentioned((Element)egm.getElement());
            targetJoinVars = egm.getPartitionVars();
            varMap = VarUtils.createJoinVarMap((Collection)sourceVars, (Collection)targetVars, sourceJoinVars, targetJoinVars, (Generator)varGen);
            sourceVars.addAll(varMap.values());
            nodeTransform = NodeTransformRenameMap.create((Map)varMap);
            newJoin = join.applyNodeTransform((NodeTransform)nodeTransform);
            result.getMandatoryJoins().add(newJoin);
        }
        for (GraphPartitionJoin join : query.getOptionalJoins()) {
            egm = join.getEntityGraphFragment();
            targetVars = ElementUtils.getVarsMentioned((Element)egm.getElement());
            targetJoinVars = egm.getPartitionVars();
            varMap = VarUtils.createJoinVarMap((Collection)sourceVars, (Collection)targetVars, sourceJoinVars, targetJoinVars, (Generator)varGen);
            sourceVars.addAll(varMap.values());
            nodeTransform = NodeTransformRenameMap.create((Map)varMap);
            newJoin = join.applyNodeTransform((NodeTransform)nodeTransform);
            result.getOptionalJoins().add(newJoin);
        }
        return result;
    }

    public static EntityQueryBasic assembleEntityAndAttributeParts(EntityQueryImpl queryRaw) {
        EntityQueryImpl queryTmp = EntityQueryRx.alignVariables(queryRaw);
        EntityQueryImpl query = EntityQueryRx.mergeFetchGroups(queryTmp);
        GraphPartitionJoin join = (GraphPartitionJoin)Iterables.getFirst(query.getMandatoryJoins(), (Object)new GraphPartitionJoin(EntityGraphFragment.empty(query.getBaseQuery().getPartitionVars())));
        GraphPartitionJoin optional = (GraphPartitionJoin)Iterables.getFirst(query.getOptionalJoins(), (Object)new GraphPartitionJoin(EntityGraphFragment.empty(query.getBaseQuery().getPartitionVars())));
        EntityQueryBasic result = new EntityQueryBasic();
        result.setBaseQuery(queryRaw.getBaseQuery());
        result.setAttributeFragment(join.getEntityGraphFragment());
        result.setOptionalAttributeFragment(optional.getEntityGraphFragment());
        return result;
    }

    public static EntityQueryImpl mergeFetchGroups(EntityQueryImpl query) {
        String lfgn;
        Query baseQuery = query.getBaseQuery().getStandardQuery();
        List<Var> partitionVars = query.getBaseQuery().getPartitionVars();
        ListMultimap rawFetchGroups = MultimapBuilder.hashKeys().arrayListValues().build();
        ListMultimap rawOptionalFetchGroups = MultimapBuilder.hashKeys().arrayListValues().build();
        ArrayList<Element> combinedFilter = new ArrayList<Element>();
        combinedFilter.add(baseQuery.getQueryPattern());
        for (GraphPartitionJoin graphPartitionJoin : query.getMandatoryJoins()) {
            List list = ElementUtils.toElementList((Element)graphPartitionJoin.getEntityGraphFragment().getElement());
            Element element = ElementUtils.groupIfNeeded((Iterable)list);
            lfgn = graphPartitionJoin.getLazyFetchGroupName();
            combinedFilter.add(element);
            rawFetchGroups.put((Object)lfgn, (Object)graphPartitionJoin);
        }
        for (GraphPartitionJoin graphPartitionJoin : query.getOptionalJoins()) {
            List list = ElementUtils.toElementList((Element)graphPartitionJoin.getEntityGraphFragment().getElement());
            Element element = ElementUtils.groupIfNeeded((Iterable)list);
            lfgn = graphPartitionJoin.getLazyFetchGroupName();
            rawOptionalFetchGroups.put((Object)lfgn, (Object)graphPartitionJoin);
        }
        ArrayList<GraphPartitionJoin> fetchGroups = new ArrayList<GraphPartitionJoin>();
        for (Map.Entry entry : rawFetchGroups.asMap().entrySet()) {
            String string = (String)entry.getKey();
            if (((Collection)entry.getValue()).isEmpty()) continue;
            GraphPartitionJoin newGp = EntityQueryRx.merge(string, partitionVars, (Collection)entry.getValue(), false);
            fetchGroups.add(newGp);
        }
        ArrayList<GraphPartitionJoin> arrayList = new ArrayList<GraphPartitionJoin>();
        for (Map.Entry entry : rawOptionalFetchGroups.asMap().entrySet()) {
            String groupName = (String)entry.getKey();
            if (((Collection)entry.getValue()).isEmpty()) continue;
            GraphPartitionJoin newGp = EntityQueryRx.merge(groupName, partitionVars, (Collection)entry.getValue(), true);
            arrayList.add(newGp);
        }
        EntityQueryImpl entityQueryImpl = new EntityQueryImpl();
        entityQueryImpl.setBaseQuery(query.getBaseQuery());
        entityQueryImpl.getMandatoryJoins().addAll(fetchGroups);
        entityQueryImpl.getOptionalJoins().addAll(arrayList);
        return entityQueryImpl;
    }

    public static GraphPartitionJoin merge(String groupName, List<Var> partitionVars, Collection<? extends GraphPartitionJoin> gps, boolean isOptional) {
        Element newElement = ElementUtils.groupIfNeeded((Iterable)gps.stream().map(GraphPartitionJoin::getEntityGraphFragment).map(EntityGraphFragment::getElement).map(ElementUtils::toElementList).map(list -> isOptional ? Collections.singletonList(new ElementOptional(ElementUtils.groupIfNeeded((Iterable)list))) : list).flatMap(Collection::stream).collect(Collectors.toList()));
        BasicPattern bgp = new BasicPattern();
        gps.stream().map(gp -> gp.getEntityGraphFragment().getEntityTemplate().getTemplate().getBGP()).forEach(arg_0 -> ((BasicPattern)bgp).addAll(arg_0));
        Template newTemplate = new Template(bgp);
        List<Node> newEntityNodes = gps.stream().map(GraphPartitionJoin::getEntityGraphFragment).map(EntityGraphFragment::getEntityTemplate).map(EntityTemplate::getEntityNodes).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        Map<Node, ExprList> newBnodeIdMapping = gps.stream().map(GraphPartitionJoin::getEntityGraphFragment).map(EntityGraphFragment::getEntityTemplate).map(EntityTemplate::getBnodeIdMapping).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        EntityTemplateImpl newEntityTemplate = new EntityTemplateImpl(newEntityNodes, newTemplate, newBnodeIdMapping);
        EntityGraphFragment newFragment = new EntityGraphFragment(partitionVars, newEntityTemplate, newElement);
        List<Var> parentJoinVars = null;
        List<GraphPartitionJoin> subJoins = null;
        GraphPartitionJoin result = new GraphPartitionJoin(newFragment, parentJoinVars, groupName, subJoins);
        return result;
    }

    public static Flowable<Map.Entry<Binding, Table>> execSelectPartitioned(QueryExecutionFactoryQuery conn, Query selectQuery, List<Var> partitionVars) {
        if (!selectQuery.isSelectType()) {
            throw new RuntimeException("Query must be of select type");
        }
        Function bindingToKey = SparqlRx.createGrouper(partitionVars, (boolean)false);
        AggCollection aggregator = new AggCollection(TableFactory::create, Function.identity(), Table::addBinding);
        Flowable result = SparqlRx.execSelectRaw((QueryExecutionFactoryQuery)conn, (Query)selectQuery).compose(EntityQueryRx.aggregateConsecutiveItemsWithSameKey(bindingToKey, aggregator));
        return result;
    }

    public static Flowable<GraphPartitionWithEntities> execConstructPartitionedOld(QueryExecutionFactoryQuery conn, EntityQueryImpl queryEx, Supplier<Graph> graphSupplier, ExprListEval exprListEval) {
        EntityQueryBasic assembledQuery = EntityQueryRx.assembleEntityAndAttributeParts(queryEx);
        return EntityQueryRx.execConstructPartitionedOld(conn, assembledQuery, graphSupplier, exprListEval);
    }

    public static Flowable<GraphPartitionWithEntities> execConstructPartitionedOld(QueryExecutionFactoryQuery conn, EntityQueryBasic queryEx, Supplier<Graph> graphSupplier, ExprListEval exprListEval) {
        EntityQueryProcessed tmp = EntityQueryRx.processEntityQuery(queryEx, false, graphSupplier, exprListEval);
        return EntityQueryRx.execQueryActual(conn, tmp.partitionVars, tmp.trackedTemplateNodes, tmp.selectQuery, tmp.tableToGraph);
    }

    public static EntityQueryProcessed processEntityQuery(EntityQueryBasic queryEx, boolean forceSubSelect) {
        return EntityQueryRx.processEntityQuery(queryEx, forceSubSelect, GraphFactory::createDefaultGraph, EntityQueryRx::defaultEvalToNode);
    }

    public static EntityQueryProcessed processEntityQuery(EntityQueryBasic queryEx, boolean forceSubSelect, Supplier<Graph> graphSupplier, ExprListEval exprListEval) {
        Query selectQuery;
        EntityBaseQuery baseQuery = queryEx.getBaseQuery();
        EntityTemplate directTemplate = baseQuery.getEntityTemplate();
        EntityTemplate attributeTemplate = queryEx.getAttributeFragment().getEntityTemplate();
        EntityTemplate optionalTemplate = queryEx.getOptionalAttributeFragment().getEntityTemplate();
        EntityTemplate effectiveTemplate = EntityTemplate.merge(directTemplate, attributeTemplate, optionalTemplate);
        Query standardQuery = baseQuery.getStandardQuery();
        Element filterElement = standardQuery.getQueryPattern();
        Template template = effectiveTemplate.getTemplate();
        Map<Node, ExprList> idMapping = directTemplate.getBnodeIdMapping();
        List<Var> partitionVars = baseQuery.getPartitionVars();
        List<SortCondition> partitionOrderBy = baseQuery.getPartitionOrderBy();
        Set<Var> essentialProjectVars = EntityQueryRx.getEssentialProjectVars(template, idMapping);
        LinkedHashSet<Node> trackedTemplateNodes = new LinkedHashSet<Node>(effectiveTemplate.getEntityNodes());
        Set blacklist = QueryUtils.mentionedVars((Query)standardQuery);
        VarGeneratorBlacklist varGen = VarGeneratorBlacklist.create((String)"sortKey", (Collection)blacklist);
        Element attributeElement = queryEx.getAttributeFragment().getElement();
        Element optionalAttributeElement = queryEx.getOptionalAttributeFragment().getElement();
        boolean needsSubSelect = forceSubSelect || partitionOrderBy != null && !partitionOrderBy.isEmpty() || standardQuery.hasLimit() || standardQuery.hasOffset();
        List filterElts = ElementUtils.toElementList((Element)filterElement);
        List attrElts = ElementUtils.toElementList((Element)attributeElement);
        List optAttrElts = ElementUtils.toElementList((Element)optionalAttributeElement);
        Element effectiveFilter = filterElement;
        Element effectiveAttribute = attributeElement;
        if (!needsSubSelect) {
            effectiveFilter = ElementUtils.groupIfNeeded((Iterable)Iterables.concat((Iterable)filterElts, (Iterable)attrElts, (Iterable)optAttrElts));
            effectiveAttribute = null;
            standardQuery.setQueryPattern(effectiveFilter);
            selectQuery = EntityQueryRx.preprocessQueryForPartitionWithoutSubSelect(standardQuery, partitionVars, essentialProjectVars, true);
        } else {
            effectiveFilter = ElementUtils.groupIfNeeded((Iterable)Iterables.concat((Iterable)filterElts, (Iterable)attrElts));
            effectiveAttribute = !directTemplate.getTemplate().getTriples().isEmpty() ? ElementUtils.groupIfNeeded((Iterable)Iterables.concat((Iterable)filterElts, (Iterable)attrElts, (Iterable)optAttrElts)) : ElementUtils.groupIfNeeded((Iterable)Iterables.concat((Iterable)attrElts, (Iterable)optAttrElts));
            standardQuery.setQueryPattern(effectiveFilter);
            selectQuery = EntityQueryRx.preprocessQueryForPartitionWithSubSelect(standardQuery, partitionVars, effectiveAttribute, essentialProjectVars, partitionOrderBy, (Generator<Var>)varGen);
        }
        System.err.println(selectQuery);
        Function<Table, AggObjectGraph.AccObjectGraph> tableToGraph = EntityQueryRx.createTableToGraphMapper(template, trackedTemplateNodes, idMapping, exprListEval, graphSupplier);
        return new EntityQueryProcessed(partitionVars, selectQuery, trackedTemplateNodes, tableToGraph);
    }

    public static Flowable<GraphPartitionWithEntities> execQueryActual(QueryExecutionFactoryQuery conn, List<Var> partitionVars, Set<Node> trackedTemplateNodes, Query selectQuery, Function<Table, AggObjectGraph.AccObjectGraph> tableToGraph) {
        Flowable result = EntityQueryRx.execSelectPartitioned(conn, selectQuery, partitionVars).map(keyAndTable -> {
            Binding partitionKey = (Binding)keyAndTable.getKey();
            Table table = (Table)keyAndTable.getValue();
            AggObjectGraph.AccObjectGraph acc = (AggObjectGraph.AccObjectGraph)tableToGraph.apply(table);
            Graph graph = acc.getValue();
            Set<Node> entities = trackedTemplateNodes.stream().map(rootNode -> acc.getTrackedNodes(rootNode)).flatMap(Collection::stream).collect(Collectors.toSet());
            GraphPartitionWithEntities r = new GraphPartitionWithEntities(partitionKey, graph, entities);
            return r;
        });
        return result;
    }

    public static Flowable<RDFNode> execConstructEntities(QueryExecutionFactoryQuery conn, EntityQueryBasic queryEx, Supplier<Graph> graphSupplier, ExprListEval exprListEval) {
        Flowable result = EntityQueryRx.execConstructPartitionedOld(conn, queryEx, graphSupplier, exprListEval).flatMap(graphPartition -> Flowable.fromIterable(graphPartition.getRoots()).map(node -> {
            Graph graph = graphPartition.getGraph();
            Model model = ModelFactory.createModelForGraph((Graph)graph);
            RDFNode r = ModelUtils.convertGraphNodeToRDFNode((Node)node, (Model)model);
            return r;
        }));
        return result;
    }

    public static Flowable<Quad> execConstructEntitiesNg(QueryExecutionFactoryQuery conn, EntityQueryBasic queryEx) {
        return EntityQueryRx.execConstructEntitiesNg(conn, queryEx, GraphFactory::createDefaultGraph, EntityQueryRx::defaultEvalToNode);
    }

    public static Flowable<Quad> execConstructEntitiesNg(QueryExecutionFactoryQuery conn, EntityQueryBasic queryEx, Supplier<Graph> graphSupplier, ExprListEval exprListEval) {
        Random random = new Random();
        String namedGraphHash = BaseEncoding.base64Url().encode(Hashing.sha256().hashLong(random.nextLong()).asBytes());
        Node hasEntity = NodeFactory.createURI((String)"http://sparql.org/hasEntity");
        return EntityQueryRx.execConstructPartitionedOld(conn, queryEx, graphSupplier, exprListEval).zipWith(LongStream.iterate(0L, i -> i + 1L)::iterator, AbstractMap.SimpleEntry::new).flatMap(graphPartitionAndIndex -> {
            long index = (Long)graphPartitionAndIndex.getValue();
            GraphPartitionWithEntities graphPartition = (GraphPartitionWithEntities)graphPartitionAndIndex.getKey();
            Node ngIri = NodeFactory.createURI((String)("urn:sparql-partition:" + namedGraphHash + "-" + index));
            ArrayList<Quad> quads = new ArrayList<Quad>();
            for (Node entityNode : graphPartition.getRoots()) {
                Quad q = new Quad(ngIri, ngIri, hasEntity, entityNode);
                quads.add(q);
                ExtendedIterator it = graphPartition.getGraph().find();
                while (it.hasNext()) {
                    Quad quad = new Quad(ngIri, (Triple)it.next());
                    quads.add(quad);
                }
            }
            return Flowable.fromIterable(quads);
        });
    }

    public static Function<Table, AggObjectGraph.AccObjectGraph> createTableToGraphMapper(Template template, Set<? extends Node> trackedTemplateNodes, Map<Node, ExprList> idMapping, ExprListEval exprListEval, Supplier<Graph> graphSupplier) {
        AggObjectGraph graphAgg = EntityQueryRx.createGraphAggregator(template, trackedTemplateNodes, idMapping, exprListEval, graphSupplier);
        return table -> {
            AggObjectGraph.AccObjectGraph acc = graphAgg.createAccumulator();
            table.rows().forEachRemaining(arg_0 -> ((AggObjectGraph.AccObjectGraph)acc).accumulate(arg_0));
            return acc;
        };
    }

    public static Function<Binding, Node> createKeyFunction(Node root, Map<Node, ExprList> idMapping, ExprListEval exprListEval) {
        Function<Binding, Node> result;
        if (root.isVariable()) {
            Var rootVar = (Var)root;
            result = b -> b.get(rootVar);
        } else if (root.isBlank()) {
            ExprList el = idMapping.get(root);
            Objects.requireNonNull(el, "blank node as the root must be mapped to id-generating expressions");
            result = b -> exprListEval.eval(el, (Binding)b);
        } else {
            result = b -> root;
        }
        return result;
    }

    public static List<Var> getEntityVars(Node root, Map<Node, ExprList> idMapping) {
        List<Var> result;
        if (root.isVariable()) {
            Var rootVar = (Var)root;
            result = Collections.singletonList(rootVar);
        } else if (root.isBlank()) {
            ExprList el = idMapping.get(root);
            Objects.requireNonNull(el, "blank node as the root must be mapped to id-generating expressions");
            LinkedHashSet vars = new LinkedHashSet();
            ExprVars.varsMentioned(vars, (ExprList)el);
            result = new ArrayList(vars);
        } else {
            result = Collections.emptyList();
        }
        return result;
    }

    public static AggObjectGraph createGraphAggregator(Template template, Set<? extends Node> trackedTemplateNodes, Map<Node, ExprList> idMap, ExprListEval exprListEval, Supplier<Graph> graphSupplier) {
        Map<Node, Function> nodeIdGenMap = idMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> binding -> exprListEval.eval((ExprList)e.getValue(), (Binding)binding)));
        AggObjectGraph result = new AggObjectGraph(template, trackedTemplateNodes, graphSupplier, nodeIdGenMap);
        return result;
    }

    public static Node defaultEvalToNode(ExprList exprs, Binding binding) {
        List nodes = exprs.getList().stream().map(expr -> ExprUtils.eval((Expr)expr, (Binding)binding)).map(NodeValue::asNode).collect(Collectors.toList());
        String label = nodes.toString();
        Node result = NodeFactory.createBlankNode((String)label);
        return result;
    }

    public static <ITEM, KEY, VALUE> FlowableTransformer<ITEM, Map.Entry<KEY, VALUE>> aggregateConsecutiveItemsWithSameKey(Function<? super ITEM, KEY> itemToKey, Aggregator<? super ITEM, ?, VALUE> aggregator) {
        return upstream -> upstream.lift((FlowableOperator)FlowableOperatorCollapseRuns.create((CollapseRunsSpec)CollapseRunsSpec.create((Function)itemToKey, groupKey -> aggregator.createAccumulator(), Accumulator::accumulate))).map(keyAndAcc -> {
            Object groupKey = keyAndAcc.getKey();
            Accumulator accGraph = (Accumulator)keyAndAcc.getValue();
            Object g = accGraph.getValue();
            return Maps.immutableEntry(groupKey, (Object)g);
        });
    }

    public static Set<Var> getEssentialProjectVars(Template template, Map<Node, ExprList> idMapping) {
        LinkedHashSet<Var> result = new LinkedHashSet<Var>();
        for (ExprList exprs : idMapping.values()) {
            ExprVars.varsMentioned(result, (ExprList)exprs);
        }
        result.addAll(QuadPatternUtils.getVarsMentioned((Iterable)template.getQuads()));
        return result;
    }

    public static Query prependToOrderBy(Query query, List<SortCondition> sortConditions) {
        if (sortConditions != null && !sortConditions.isEmpty()) {
            Stream newConditions;
            if (query.hasOrderBy()) {
                newConditions = Sets.newLinkedHashSet((Iterable)Iterables.concat(sortConditions, (Iterable)query.getOrderBy())).stream();
                query.getOrderBy().clear();
            } else {
                newConditions = sortConditions.stream();
            }
            newConditions.forEach(arg_0 -> ((Query)query).addOrderBy(arg_0));
        }
        return query;
    }

    public static List<SortCondition> createSortConditionsFromExprs(Iterable<Expr> exprs, int dir) {
        List result = exprs == null ? null : Streams.stream(exprs).map(expr -> new SortCondition(expr, dir)).collect(Collectors.toList());
        return result;
    }

    public static List<SortCondition> createSortConditionsFromVars(Iterable<Var> vars, int dir) {
        List result = vars == null ? null : Streams.stream(vars).map(var -> new SortCondition((Expr)new ExprVar(var), dir)).collect(Collectors.toList());
        return result;
    }

    public static Query preprocessQueryForPartitionWithSubSelect(Query entityQuery, List<Var> partitionVars, Element attributeElement, Set<Var> requiredVars, List<SortCondition> partitionOrderBy, Generator<Var> varGenerator) {
        boolean hasSlice;
        Query result = EntityQueryRx.preprocessQueryForPartitionWithoutSubSelect(entityQuery, partitionVars, requiredVars, true);
        partitionOrderBy = partitionOrderBy == null ? Collections.emptyList() : partitionOrderBy;
        List sortKeyVars = partitionOrderBy.stream().map(x -> (Var)varGenerator.next()).collect(Collectors.toList());
        Element basePattern = result.getQueryPattern();
        Query subSelect = new Query();
        subSelect.setQuerySelectType();
        subSelect.setQueryPattern(basePattern);
        for (Var partitionVar : partitionVars) {
            subSelect.addResultVar((Node)partitionVar);
            subSelect.addGroupBy((Node)partitionVar);
        }
        for (int i = 0; i < partitionOrderBy.size(); ++i) {
            SortCondition sc = (SortCondition)partitionOrderBy.get(i);
            Var scv = (Var)sortKeyVars.get(i);
            Expr rawExpr = sc.getExpression();
            Expr expr = ExprTransformer.transform((ExprTransform)new ExprTransformAllocAggregate(subSelect), (Expr)rawExpr);
            subSelect.addResultVar((Node)scv, expr);
            subSelect.addOrderBy(new SortCondition(expr, sc.getDirection()));
        }
        boolean bl = hasSlice = result.hasLimit() || result.hasOffset();
        if (hasSlice) {
            boolean useWrapper = false;
            if (useWrapper) {
                Query sliceWrapper = new Query();
                sliceWrapper.setQuerySelectType();
                sliceWrapper.setQueryResultStar(true);
                sliceWrapper.setQueryPattern((Element)new ElementSubQuery(subSelect));
                result.setQueryPattern((Element)new ElementSubQuery(sliceWrapper));
                subSelect = sliceWrapper;
            }
            subSelect.setLimit(result.getLimit());
            subSelect.setOffset(result.getOffset());
            result.setLimit(Long.MIN_VALUE);
            result.setOffset(Long.MIN_VALUE);
        }
        ElementGroup newPattern = ElementUtils.createElementGroup((Element[])new Element[]{new ElementSubQuery(subSelect)});
        ElementUtils.copyElements((ElementGroup)newPattern, (Element)attributeElement);
        result.setQueryPattern((Element)newPattern);
        ArrayList<SortCondition> partitionScs = new ArrayList<SortCondition>();
        for (int i = 0; i < partitionOrderBy.size(); ++i) {
            SortCondition sc = (SortCondition)partitionOrderBy.get(i);
            Var scv = (Var)sortKeyVars.get(i);
            partitionScs.add(new SortCondition(scv, sc.getDirection()));
        }
        EntityQueryRx.prependToOrderBy(result, partitionScs);
        return result;
    }

    public static Query preprocessQueryForPartitionWithoutSubSelect(Query baseQuery, List<Var> partitionVars, Set<Var> requiredVars, boolean sortRowsByPartitionVars) {
        Query selectQuery = baseQuery.cloneQuery();
        selectQuery.setQuerySelectType();
        selectQuery.setQueryResultStar(false);
        VarExprList project = selectQuery.getProject();
        VarExprListUtils.addAbsentVars((VarExprList)project, partitionVars);
        VarExprListUtils.addAbsentVars((VarExprList)project, requiredVars);
        if (project.isEmpty()) {
            Set patternVars = SetUtils.asSet((Iterable)PatternVars.vars((Element)selectQuery.getQueryPattern()));
            if (patternVars.isEmpty()) {
                selectQuery.setQueryResultStar(true);
            } else {
                Var v = (Var)patternVars.iterator().next();
                selectQuery.setQueryResultStar(false);
                selectQuery.getProject().add(v);
            }
        }
        selectQuery.setDistinct(true);
        if (sortRowsByPartitionVars) {
            List<SortCondition> newSortConditions = EntityQueryRx.createSortConditionsFromVars(partitionVars, -2);
            EntityQueryRx.prependToOrderBy(selectQuery, newSortConditions);
        }
        return selectQuery;
    }

    public static class EntityQueryProcessed {
        protected List<Var> partitionVars;
        protected Query selectQuery;
        protected Set<Node> trackedTemplateNodes;
        protected Function<Table, AggObjectGraph.AccObjectGraph> tableToGraph;

        public EntityQueryProcessed(List<Var> partitionVars, Query selectQuery, Set<Node> trackedTemplateNodes, Function<Table, AggObjectGraph.AccObjectGraph> tableToGraph) {
            this.partitionVars = partitionVars;
            this.selectQuery = selectQuery;
            this.trackedTemplateNodes = trackedTemplateNodes;
            this.tableToGraph = tableToGraph;
        }

        public Query getInnerSelect() {
            ElementGroup grp = (ElementGroup)this.selectQuery.getQueryPattern();
            ElementSubQuery subQueryElt = (ElementSubQuery)grp.get(0);
            Query result = subQueryElt.getQuery();
            return result;
        }

        public List<Var> getPartitionVars() {
            return this.partitionVars;
        }

        public Query getSelectQuery() {
            return this.selectQuery;
        }

        public Set<Node> getTrackedTemplateNodes() {
            return this.trackedTemplateNodes;
        }

        public Function<Table, AggObjectGraph.AccObjectGraph> getTableToGraph() {
            return this.tableToGraph;
        }
    }
}

