/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.rx.entity.util;

import java.io.OutputStream;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.aksw.commons.collections.IterableUtils;
import org.aksw.jena_sparql_api.rdf.collections.ListFromRDFList;
import org.aksw.jena_sparql_api.rx.entity.util.IdVocab;
import org.aksw.jenax.arq.dataset.api.DatasetOneNg;
import org.aksw.jenax.arq.dataset.impl.DatasetOneNgImpl;
import org.aksw.jenax.arq.util.node.NodeUtils;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.arq.util.triple.GraphVarImpl;
import org.aksw.jenax.arq.util.var.Vars;
import org.aksw.jenax.sparql.fragment.api.Fragment1;
import org.aksw.jenax.sparql.fragment.impl.Concept;
import org.aksw.jenax.sparql.query.rx.SparqlRx;
import org.apache.jena.graph.FrontsNode;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.graph.NodeTransformLib;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementNamedGraph;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class GraphEntityUtils {
    public static Dataset resolveIds(Dataset dataset) {
        Dataset result = DatasetFactory.create();
        result.asDatasetGraph().find(Node.ANY, Node.ANY, IdVocab.compositeId.asNode(), Node.ANY);
        return null;
    }

    public static LocalDateTime createTimestamp(ZoneOffset zoneOffset) {
        Instant now = Instant.now();
        return LocalDateTime.ofEpochSecond(now.getEpochSecond(), now.getNano(), zoneOffset);
    }

    public static String createUtcGraphTimestamp() {
        LocalDateTime ldt = GraphEntityUtils.createTimestamp(ZoneOffset.UTC);
        return "#" + ldt.toString();
    }

    public static DatasetOneNg getOrCreateModel(Dataset dataset, RDFNode ... rdfNodes) {
        return GraphEntityUtils.getOrCreateModel(dataset, Arrays.asList(rdfNodes).stream().map(FrontsNode::asNode).collect(Collectors.toList()));
    }

    public static DatasetOneNg getOrCreateModel(Dataset dataset, Node ... nodes) {
        return GraphEntityUtils.getOrCreateModel(dataset, Arrays.asList(nodes));
    }

    public static DatasetOneNg getOrCreateModel(Dataset dataset, List<Node> nodes) {
        return GraphEntityUtils.getOrCreateModel(dataset, nodes, GraphEntityUtils::createUtcGraphTimestamp);
    }

    public static List<Node> findEntities(Dataset dataset, List<Node> nodes, boolean isOpen) {
        Fragment1 ur = GraphEntityUtils.createRelationForCompositeId(nodes, isOpen);
        ur = new Concept((Element)new ElementNamedGraph((Node)ur.getVar(), ur.getElement()), ur.getVar());
        Query query = ur.asQuery();
        List result = (List)SparqlRx.execConcept(() -> QueryExecutionFactory.create((Query)query, (Dataset)dataset), (Var)ur.getVar()).map(FrontsNode::asNode).toList().blockingGet();
        return result;
    }

    public static Node findEntity(Dataset dataset, List<Node> nodes) {
        try {
            return (Node)IterableUtils.expectZeroOrOneItems(GraphEntityUtils.findEntities(dataset, nodes, false));
        }
        catch (Exception e) {
            throw new RuntimeException("Lookup failed because entity was not unqiue - key: " + String.valueOf(nodes), e);
        }
    }

    public static DatasetOneNg getOrCreateModel(Dataset dataset, String ... strings) {
        List nodes = NodeUtils.createLiteralNodes(Arrays.asList(strings));
        DatasetOneNg result = GraphEntityUtils.getOrCreateModel(dataset, nodes);
        return result;
    }

    public static Resource getSelfResource(Dataset dataset, List<Node> nodes) {
        Resource result = Optional.ofNullable(GraphEntityUtils.getModel(dataset, nodes)).map(DatasetOneNg::getSelfResource).orElse(null);
        return result;
    }

    public static DatasetOneNg getModel(Dataset dataset, List<Node> nodes) {
        Node match = GraphEntityUtils.findEntity(dataset, nodes);
        DatasetOneNg r = match == null ? null : DatasetOneNgImpl.create((Dataset)dataset, (Node)match);
        return r;
    }

    public static DatasetOneNg newModelByTimestamp(Dataset dataset) {
        String graphName = GraphEntityUtils.createUtcGraphTimestamp();
        Node node = NodeFactory.createURI((String)graphName.toString());
        DatasetOneNg r = DatasetOneNgImpl.create((Dataset)dataset, (Node)node);
        return r;
    }

    public static DatasetOneNg getOrCreateModel(Dataset dataset, List<Node> nodes, Supplier<String> graphNameFactory) {
        Node match = GraphEntityUtils.findEntity(dataset, nodes);
        if (match == null) {
            String newGraphName = graphNameFactory.get();
            match = NodeFactory.createURI((String)newGraphName);
            Resource s = dataset.getNamedModel(newGraphName).createResource(newGraphName);
            ListFromRDFList.create((Resource)s, (Property)IdVocab.compositeId).asNodes().addAll(nodes);
        }
        DatasetOneNg r = DatasetOneNgImpl.create((Dataset)dataset, (Node)match);
        return r;
    }

    public static Fragment1 createRelationForEntity(List<Node> nodes, boolean isOpen) {
        Fragment1 ur = GraphEntityUtils.createRelationForCompositeId(nodes, isOpen);
        ur = new Concept((Element)new ElementNamedGraph((Node)ur.getVar(), ur.getElement()), ur.getVar());
        return ur;
    }

    public static Fragment1 createRelationForCompositeId(List<Node> nodes, boolean open) {
        Model m = ModelFactory.createModelForGraph((Graph)new GraphVarImpl());
        Var v = Vars.g;
        Resource r = m.wrapAsResource((Node)v);
        ListFromRDFList.create((Resource)r, (Property)IdVocab.compositeId).asNodes().addAll(nodes);
        if (open) {
            m.removeAll(null, RDF.rest, (RDFNode)RDF.nil);
        }
        NodeTransform subst = n -> n.isBlank() ? Var.alloc((String)n.getBlankNodeLabel()) : n;
        Concept result = new Concept((Element)ElementUtils.createElementTriple((Iterable)m.getGraph().find().mapWith(t -> NodeTransformLib.transform((NodeTransform)subst, (Triple)t)).toList()), v);
        return result;
    }

    public static void main(String[] args) {
        List<Node> id1 = Arrays.asList(RDF.Nodes.type, RDFS.Nodes.label);
        List<Node> id2 = Arrays.asList(RDF.Nodes.type, RDFS.Nodes.comment);
        System.out.println(GraphEntityUtils.createRelationForCompositeId(id1, false).asQuery());
        Dataset ds = DatasetFactory.create();
        GraphEntityUtils.getOrCreateModel(ds, id1).getModel().add((Resource)RDF.type, RDF.type, (RDFNode)RDF.type);
        RDFDataMgr.write((OutputStream)System.out, (Dataset)ds, (RDFFormat)RDFFormat.TRIG);
        GraphEntityUtils.getOrCreateModel(ds, id1).getModel().add((Resource)RDF.type, RDF.type, (RDFNode)RDF.type);
        GraphEntityUtils.getOrCreateModel(ds, id2).getModel().add((Resource)RDFS.comment, RDFS.comment, (RDFNode)RDFS.comment);
        RDFDataMgr.write((OutputStream)System.out, (Dataset)ds, (RDFFormat)RDFFormat.TRIG);
    }
}

