/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.rx.entity.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.aksw.jena_sparql_api.rx.entity.model.EntityTemplate;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.graph.NodeTransformLib;
import org.apache.jena.sparql.syntax.Template;

public class EntityTemplateImpl
implements EntityTemplate {
    protected List<Node> entityNodes;
    protected Template template;
    protected Map<Node, ExprList> bnodeIdMapping;

    public static Map<Node, ExprList> applyNodeTransformBnodeMap(NodeTransform nodeTransform, Map<Node, ExprList> map) {
        Map<Node, ExprList> result = map.entrySet().stream().collect(Collectors.toMap(e -> (Node)nodeTransform.apply((Object)((Node)e.getKey())), e -> NodeTransformLib.transform((NodeTransform)nodeTransform, (ExprList)((ExprList)e.getValue()))));
        return result;
    }

    public EntityTemplateImpl() {
        this(new ArrayList<Node>(), new Template(new BasicPattern()));
    }

    public EntityTemplateImpl(List<Node> entityNodes, Template template) {
        this(entityNodes, template, new LinkedHashMap<Node, ExprList>());
    }

    public EntityTemplateImpl(List<Node> entityNodes, Template template, Map<Node, ExprList> bnodeIdMapping) {
        this.entityNodes = entityNodes;
        this.template = template;
        this.bnodeIdMapping = bnodeIdMapping;
    }

    @Override
    public EntityTemplateImpl cloneTemplate() {
        return new EntityTemplateImpl(new ArrayList<Node>(this.entityNodes), new Template(BasicPattern.wrap(new ArrayList(this.template.getTriples()))), new LinkedHashMap<Node, ExprList>(this.bnodeIdMapping));
    }

    @Override
    public Template getTemplate() {
        return this.template;
    }

    @Override
    public List<Node> getEntityNodes() {
        return this.entityNodes;
    }

    @Override
    public Map<Node, ExprList> getBnodeIdMapping() {
        return this.bnodeIdMapping;
    }

    @Override
    public void setTemplate(Template template) {
        this.template = template;
    }

    public static List<Node> transformNodes(NodeTransform nodeTransform, List<? extends Node> varList) {
        ArrayList<Node> varList2 = new ArrayList<Node>(varList.size());
        for (Node node : varList) {
            Node v2 = (Node)nodeTransform.apply((Object)node);
            varList2.add(v2);
        }
        return varList2;
    }

    @Override
    public EntityTemplate applyNodeTransform(NodeTransform nodeTransform) {
        return new EntityTemplateImpl(EntityTemplateImpl.transformNodes(nodeTransform, this.entityNodes), new Template(NodeTransformLib.transform((NodeTransform)nodeTransform, (BasicPattern)this.template.getBGP())), EntityTemplateImpl.applyNodeTransformBnodeMap(nodeTransform, this.bnodeIdMapping));
    }

    public String toString() {
        return String.valueOf(this.template.getGraphPattern()) + ", entity nodes " + String.valueOf(this.entityNodes) + ", bnodeIdMapping " + String.valueOf(this.bnodeIdMapping);
    }
}

