/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.rx.entity.model;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.aksw.jena_sparql_api.rx.entity.model.EntityGraphFragment;
import org.aksw.jena_sparql_api.rx.entity.model.GraphPartitionJoin;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.Var;

public class AttributeGraphFragment {
    protected List<GraphPartitionJoin> mandatoryJoins;
    protected List<GraphPartitionJoin> optionalJoins;

    public AttributeGraphFragment() {
        this(new ArrayList<GraphPartitionJoin>(), new ArrayList<GraphPartitionJoin>());
    }

    public AttributeGraphFragment(List<GraphPartitionJoin> mandatoryJoins, List<GraphPartitionJoin> optionalJoins) {
        this.mandatoryJoins = mandatoryJoins;
        this.optionalJoins = optionalJoins;
    }

    public List<GraphPartitionJoin> getMandatoryJoins() {
        return this.mandatoryJoins;
    }

    public List<GraphPartitionJoin> getOptionalJoins() {
        return this.optionalJoins;
    }

    public void setMandatoryJoins(List<GraphPartitionJoin> mandatoryJoins) {
        this.mandatoryJoins = mandatoryJoins;
    }

    public void setOptionalJoins(List<GraphPartitionJoin> optionalJoins) {
        this.optionalJoins = optionalJoins;
    }

    public AttributeGraphFragment addMandatoryJoin(Var entityVar, Query query) {
        this.getMandatoryJoins().add(new GraphPartitionJoin(EntityGraphFragment.fromQuery(entityVar, query)));
        return this;
    }

    public AttributeGraphFragment addOptionalJoin(Var entityVar, Query query) {
        this.getOptionalJoins().add(new GraphPartitionJoin(EntityGraphFragment.fromQuery(entityVar, query)));
        return this;
    }

    public String toString() {
        String result = this.optionalJoins.stream().map(item -> "OPTIONAL " + String.valueOf(item)).collect(Collectors.joining("\n")) + this.mandatoryJoins.stream().map(item -> String.valueOf(item)).collect(Collectors.joining("\n"));
        return result;
    }
}

