/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.schema;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.shacl.engine.ShaclPaths;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.P_ReverseLink;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.PathFactory;
import org.apache.jena.vocabulary.RDF;
import org.topbraid.shacl.vocabulary.SH;

public class ShUtils {
    public static final PathAssembler DEFAULT_PATH_ASSEMBLER = new PathAssembler();

    public static Path assemblePath(Resource r) {
        return ShaclPaths.parsePath((Graph)r.getModel().getGraph(), (Node)r.asNode());
    }

    public static void main(String[] args) {
        String str = "# Example paths taken from https://www.w3.org/TR/shacl/#property-paths\n\nPREFIX ex: <http://example.org/>\nPREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nPREFIX sh: <http://www.w3.org/ns/shacl#>\n\nex:a sh:property [ sh:path ex:parent ] .\n\nex:b sh:property [ sh:path [ sh:inversePath ex:parent ] ] .\n\nex:c sh:property [ sh:path ( ex:parent ex:firstName ) ] .\n\nex:d sh:property [ sh:path ( rdf:type [ sh:zeroOrMorePath rdfs:subClassOf ] ) ] .\n\nex:e sh:property [ sh:path [ sh:alternativePath ( ex:father ex:mother  ) ] ] .\n";
        Model model = ModelFactory.createDefaultModel();
        RDFDataMgr.read((Model)model, (InputStream)new ByteArrayInputStream(str.getBytes()), (Lang)Lang.TURTLE);
        List nodeShapes = model.listResourcesWithProperty(SH.property).toList();
        for (Resource nodeShape : nodeShapes) {
            Resource x = nodeShape.getPropertyResourceValue(SH.property).getPropertyResourceValue(SH.path);
            Path path = ShUtils.assemblePath(x);
            System.out.println(String.valueOf(nodeShape) + ": " + String.valueOf(path));
        }
    }

    @Deprecated
    public static class PathAssembler {
        public Path assemblePath(Resource r) {
            Object result;
            Resource o = r.getPropertyResourceValue(SH.inversePath);
            if (o != null) {
                Path tgt = this.assemblePath(o);
                result = tgt instanceof P_Link ? new P_ReverseLink(((P_Link)tgt).getNode()) : PathFactory.pathInverse((Path)tgt);
            } else {
                o = r.getPropertyResourceValue(SH.alternativePath);
                if (o != null) {
                    List<Path> paths = this.assembleList(o);
                    result = (Path)paths.stream().reduce(PathFactory::pathAlt).orElseThrow(() -> new IllegalStateException("Zero length path encountered"));
                } else {
                    o = r.getPropertyResourceValue(SH.zeroOrOnePath);
                    if (o != null) {
                        Path tgt = this.assemblePath(o);
                        result = PathFactory.pathZeroOrOne((Path)tgt);
                    } else {
                        o = r.getPropertyResourceValue(SH.zeroOrMorePath);
                        if (o != null) {
                            Path tgt = this.assemblePath(o);
                            result = PathFactory.pathZeroOrMore1((Path)tgt);
                        } else {
                            o = r.getPropertyResourceValue(SH.oneOrMorePath);
                            if (o != null) {
                                Path tgt = this.assemblePath(o);
                                result = PathFactory.pathOneOrMore1((Path)tgt);
                            } else if (r.hasProperty(RDF.first)) {
                                List<Path> paths = this.assembleList(r);
                                result = (Path)paths.stream().reduce(PathFactory::pathSeq).orElseThrow(() -> new IllegalStateException("Zero length path encountered"));
                            } else {
                                Node node = r.asNode();
                                result = PathFactory.pathLink((Node)node);
                            }
                        }
                    }
                }
            }
            return result;
        }

        public List<Path> assembleList(Resource listNode) {
            RDFList list = (RDFList)listNode.as(RDFList.class);
            List items = list.asJavaList();
            ArrayList<Path> result = new ArrayList<Path>(items.size());
            for (RDFNode item : items) {
                Resource r = item.asResource();
                Path path = this.assemblePath(r);
                result.add(path);
            }
            return result;
        }
    }
}

