/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.collection.observable;

import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.util.Collection;
import org.aksw.commons.collection.observable.ObservableCollection;
import org.aksw.commons.collection.observable.ObservableSet;
import org.aksw.commons.collection.observable.ObservableValue;
import org.aksw.commons.collection.observable.ObservableValueFromObservableCollection;
import org.aksw.commons.collection.observable.Registration;
import org.aksw.jena_sparql_api.collection.observable.ObservableSetFromGraph;
import org.aksw.jena_sparql_api.collection.observable.SetOfNodesFromGraph;
import org.aksw.jenax.arq.util.triple.TripleFilter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;

public interface ObservableGraph
extends Graph {
    public Runnable addVetoableChangeListener(VetoableChangeListener var1);

    public Registration addPropertyChangeListener(PropertyChangeListener var1);

    public boolean delta(Collection<? extends Triple> var1, Collection<?> var2);

    default public ObservableSet<Triple> asSet() {
        return new ObservableSetFromGraph(this);
    }

    default public ObservableValue<Node> createValueField(Node source, Node predicate, boolean isForward) {
        TripleFilter dftp = TripleFilter.create((Node)source, (Node)predicate, (boolean)isForward);
        ObservableValue<Node> result = this.createValueField(source, dftp);
        return result;
    }

    default public ObservableValue<Node> createValueField(Node sourceNode, TripleFilter dftp) {
        ObservableCollection<Node> set = this.createSetField(sourceNode, dftp);
        ObservableValue result = ObservableValueFromObservableCollection.decorate(set);
        return result;
    }

    default public ObservableCollection<Node> createSetField(Node sourceNode, TripleFilter dftp) {
        ObservableCollection<Node> set = SetOfNodesFromGraph.create(this, dftp);
        return set;
    }

    default public ObservableCollection<Node> createSetField(Node source, Node predicate, boolean isForward) {
        TripleFilter dftp = TripleFilter.create((Node)source, (Node)predicate, (boolean)isForward);
        return this.createSetField(source, dftp);
    }
}

