/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.collection.observable;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Set;
import org.aksw.commons.collection.observable.CollectionChangedEvent;
import org.aksw.commons.collection.observable.CollectionChangedEventImpl;
import org.aksw.commons.collection.observable.ForwardingDeltaCollectionBase;
import org.aksw.commons.collection.observable.ObservableMap;
import org.aksw.commons.collection.observable.ObservableMapImpl;
import org.aksw.commons.collection.observable.ObservableSet;
import org.aksw.commons.collection.observable.ObservableSets;
import org.aksw.commons.collection.observable.Registration;
import org.aksw.jena_sparql_api.collection.observable.ObservableGraph;
import org.aksw.jena_sparql_api.collection.observable.ObservableGraphImpl;
import org.aksw.jenax.arq.util.triple.SetFromGraph;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class ObservableSetFromGraph
extends ForwardingDeltaCollectionBase<Triple, Set<Triple>>
implements ObservableSet<Triple> {
    protected ObservableGraph graph;

    public ObservableSetFromGraph(ObservableGraph graph) {
        super((Collection)SetFromGraph.wrap((Graph)graph));
        this.graph = graph;
    }

    public boolean delta(Collection<? extends Triple> additions, Collection<?> removals) {
        return this.getGraph().delta(additions, removals);
    }

    public ObservableGraph getGraph() {
        return this.graph;
    }

    protected PropertyChangeEvent convertEvent(PropertyChangeEvent ev) {
        CollectionChangedEvent oldEvent = (CollectionChangedEvent)ev;
        return new CollectionChangedEventImpl((Object)this, (Object)this, (Object)SetFromGraph.wrap((Graph)((Graph)oldEvent.getNewValue())), oldEvent.getAdditions(), oldEvent.getDeletions(), oldEvent.getRefreshes());
    }

    public Runnable addVetoableChangeListener(VetoableChangeListener listener) {
        return this.getGraph().addVetoableChangeListener(ev -> {
            PropertyChangeEvent newEvent = this.convertEvent(ev);
            listener.vetoableChange(newEvent);
        });
    }

    public Registration addPropertyChangeListener(PropertyChangeListener listener) {
        return this.getGraph().addPropertyChangeListener(ev -> {
            PropertyChangeEvent newEvent = this.convertEvent(ev);
            listener.propertyChange(newEvent);
        });
    }

    public static ObservableSetFromGraph decorate(Graph graph) {
        ObservableGraphImpl tmp = ObservableGraphImpl.decorate(graph);
        ObservableSetFromGraph result = new ObservableSetFromGraph(tmp);
        return result;
    }

    public static void main(String[] args) {
        ObservableSetFromGraph a = ObservableSetFromGraph.decorate(GraphFactory.createPlainGraph());
        ObservableMap map = ObservableMapImpl.decorate(new LinkedHashMap());
        ObservableSet b = map.keySet();
        ObservableSet effectiveTriples = ObservableSets.union((ObservableSet)a, (ObservableSet)b);
        effectiveTriples.addPropertyChangeListener(ev -> System.out.println(ev));
        Triple t1 = Triple.create((Node)RDF.Nodes.type, (Node)RDF.Nodes.type, (Node)RDF.Nodes.type);
        Triple t2 = Triple.create((Node)RDFS.Nodes.label, (Node)RDFS.Nodes.label, (Node)RDFS.Nodes.label);
        a.add(t1);
        map.put((Object)t2, (Object)t2);
        map.remove((Object)t2);
    }

    private static /* synthetic */ void lambda$main$3(PropertyChangeEvent event) {
        CollectionChangedEvent ev = (CollectionChangedEvent)event;
        System.out.println("Change:");
        System.out.println("  Old Value:" + String.valueOf(ev.getOldValue()));
        System.out.println("  New Value:" + String.valueOf(ev.getNewValue()));
        System.out.println("  Added: " + String.valueOf(ev.getAdditions()) + " Removed: " + String.valueOf(ev.getDeletions()));
    }

    private static /* synthetic */ void lambda$main$2(PropertyChangeEvent ev) {
        System.out.println("KeySet changed: " + String.valueOf(ev));
    }
}

