/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.collection.observable;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.util.List;
import java.util.Map;
import org.aksw.commons.collection.observable.ObservableValue;
import org.aksw.commons.collection.observable.Registration;
import org.aksw.jena_sparql_api.collection.observable.GraphChange;
import org.aksw.jenax.arq.util.triple.TripleUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;

public class RdfFieldFromExistingTriple
implements ObservableValue<Node> {
    protected GraphChange graph;
    protected Triple existingTriple;
    protected int componentIdx;

    public RdfFieldFromExistingTriple(GraphChange graph, Triple existingTriple, int componentIdx) {
        this.graph = graph;
        this.existingTriple = existingTriple;
        this.componentIdx = componentIdx;
    }

    public Node getOriginalValue() {
        return TripleUtils.getNode((Triple)this.existingTriple, (int)this.componentIdx);
    }

    public Node getLatestValue(Map<Triple, Triple> map) {
        Triple baseTriple = map.getOrDefault(this.existingTriple, this.existingTriple);
        List nodes = TripleUtils.tripleToList((Triple)baseTriple);
        Node result = (Node)nodes.get(this.componentIdx);
        return result;
    }

    public Node get() {
        return this.getLatestValue((Map<Triple, Triple>)this.graph.getTripleReplacements());
    }

    public void set(Node value) {
        Triple baseTriple = (Triple)this.graph.getTripleReplacements().getOrDefault((Object)this.existingTriple, (Object)this.existingTriple);
        List nodes = TripleUtils.tripleToList((Triple)baseTriple);
        nodes.set(this.componentIdx, value);
        Triple newTriple = TripleUtils.listToTriple((List)nodes);
        this.graph.getTripleReplacements().put((Object)this.existingTriple, (Object)newTriple);
    }

    protected PropertyChangeEvent adaptEvent(PropertyChangeEvent ev) {
        Map oldMap = (Map)ev.getOldValue();
        Map newMap = (Map)ev.getNewValue();
        Node oldValue = this.getLatestValue(oldMap);
        Node newValue = this.getLatestValue(newMap);
        return new PropertyChangeEvent(this, "value", oldValue, newValue);
    }

    public Runnable addVetoableChangeListener(VetoableChangeListener listener) {
        return this.graph.getTripleReplacements().addVetoableChangeListener(ev -> {
            PropertyChangeEvent adapted = this.adaptEvent(ev);
            listener.vetoableChange(adapted);
        });
    }

    public Registration addPropertyChangeListener(PropertyChangeListener listener) {
        return this.graph.getTripleReplacements().addPropertyChangeListener(ev -> {
            PropertyChangeEvent adapted = this.adaptEvent(ev);
            listener.propertyChange(adapted);
        });
    }
}

