/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.shape.algebra.op;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.aksw.commons.collections.generator.Generator;
import org.aksw.jena_sparql_api.shape.algebra.op.OpAnd;
import org.aksw.jena_sparql_api.shape.algebra.op.OpAssign;
import org.aksw.jena_sparql_api.shape.algebra.op.OpConcept;
import org.aksw.jena_sparql_api.shape.algebra.op.OpEnumeration;
import org.aksw.jena_sparql_api.shape.algebra.op.OpExists;
import org.aksw.jena_sparql_api.shape.algebra.op.OpFilter;
import org.aksw.jena_sparql_api.shape.algebra.op.OpFocus;
import org.aksw.jena_sparql_api.shape.algebra.op.OpForAll;
import org.aksw.jena_sparql_api.shape.algebra.op.OpSparqlConcept;
import org.aksw.jena_sparql_api.shape.algebra.op.OpTop;
import org.aksw.jena_sparql_api.shape.algebra.op.OpType;
import org.aksw.jena_sparql_api.shape.algebra.op.OpUnion;
import org.aksw.jena_sparql_api.shape.algebra.op.OpVisitor;
import org.aksw.jena_sparql_api.shape.algebra.op.PathExVisitorSparql;
import org.aksw.jenax.arq.util.expr.ExprUtils;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.arq.util.var.Vars;
import org.aksw.jenax.sparql.fragment.api.Fragment1;
import org.aksw.jenax.sparql.fragment.api.Fragment2;
import org.aksw.jenax.sparql.fragment.impl.Concept;
import org.aksw.jenax.sparql.fragment.impl.ConceptOps;
import org.aksw.jenax.sparql.fragment.impl.ConceptUtils;
import org.aksw.jenax.sparql.fragment.impl.Fragment2Impl;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.vocabulary.RDF;

public class OpVisitorSparql
implements OpVisitor<Fragment1> {
    protected PathExVisitorSparql pathVisitor;
    protected Generator<Var> generator;

    public OpVisitorSparql(Generator<Var> generator) {
        this.generator = generator;
    }

    @Override
    public Fragment1 visit(OpAssign op) {
        return null;
    }

    @Override
    public Fragment1 visit(OpAnd op) {
        Fragment1 a = op.getLeft().accept(this);
        Fragment1 b = op.getRight().accept(this);
        Fragment1 result = ConceptOps.intersect((Fragment1)a, (Fragment1)b, this.generator);
        return result;
    }

    @Override
    public Fragment1 visit(OpUnion op) {
        Fragment1 a = op.getLeft().accept(this);
        Fragment1 b = op.getRight().accept(this);
        Fragment1 result = ConceptOps.union((Fragment1)a, (Fragment1)b, this.generator);
        return result;
    }

    @Override
    public Fragment1 visit(OpExists op) {
        Fragment2 relation = op.getRole();
        Fragment1 filler = op.getSubOp().accept(this);
        Fragment1 result = ConceptOps.exists((Fragment2)relation, (Fragment1)filler, this.generator);
        return result;
    }

    @Override
    public Fragment1 visit(OpForAll op) {
        Fragment2 relation = op.getRole();
        Fragment1 filler = op.getSubOp().accept(this);
        Fragment1 result = ConceptOps.forAllIfRolePresent((Fragment2)relation, (Fragment1)filler, this.generator);
        return result;
    }

    @Override
    public Fragment1 visit(OpSparqlConcept op) {
        Concept result = op.getConcept();
        return result;
    }

    @Override
    public Fragment1 visit(OpType op) {
        Node node = op.getType();
        ElementTriplesBlock e = ElementUtils.createElement((Triple)Triple.create((Node)Vars.s, (Node)RDF.type.asNode(), (Node)node));
        Concept result = new Concept((Element)e, Vars.s);
        return result;
    }

    @Override
    public Fragment1 visit(OpTop op) {
        Concept result = Concept.TOP;
        return result;
    }

    @Override
    public Fragment1 visit(OpConcept op) {
        Concept result = op.getConcept();
        return result;
    }

    @Override
    public Fragment1 visit(OpFilter op) {
        Expr expr = op.getExpr();
        Fragment1 concept = op.getSubOp().accept(this);
        Var conceptVar = concept.getVar();
        Map<Var, Var> varMap = Collections.singletonMap(Vars.lodash, conceptVar);
        Expr newExpr = ExprUtils.applyNodeTransform((Expr)expr, varMap);
        Element newElement = ElementUtils.mergeElements((Element)concept.getElement(), (Element)new ElementFilter(newExpr));
        Concept result = new Concept(newElement, conceptVar);
        return result;
    }

    @Override
    public Fragment1 visit(OpFocus op) {
        Fragment1 concept = op.getSubOp().accept(this);
        Path path = op.getPath();
        Fragment2 relation = Fragment2Impl.create((Path)path);
        Fragment1 result = ConceptUtils.getRelatedConcept((Fragment1)concept, (Fragment2)relation);
        return result;
    }

    @Override
    public Fragment1 visit(OpEnumeration op) {
        List<Node> nodes = op.getNodes();
        Fragment1 result = ConceptUtils.createConcept(nodes);
        return result;
    }
}

