/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.entity.graph.metamodel;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.aksw.jena_sparql_api.entity.graph.metamodel.PredicateStats;
import org.aksw.jena_sparql_api.entity.graph.metamodel.ResourceGraphMetamodel;
import org.aksw.jenax.annotation.reprogen.HashId;
import org.aksw.jenax.annotation.reprogen.Inverse;
import org.aksw.jenax.annotation.reprogen.Iri;
import org.aksw.jenax.annotation.reprogen.IriNs;
import org.aksw.jenax.annotation.reprogen.KeyIri;
import org.aksw.jenax.annotation.reprogen.ResourceView;
import org.aksw.jenax.arq.util.node.NodeUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Resource;

@HashId
@ResourceView
public interface RGDMetamodel
extends Resource {
    @HashId
    @Inverse
    @Iri(value="urn:fwd")
    public ResourceGraphMetamodel getFwdRef();

    @HashId
    @Inverse
    @Iri(value="urn:bwd")
    public ResourceGraphMetamodel getBwdRef();

    @IriNs(value="eg")
    public Boolean isPredicateComplete();

    @IriNs(value="eg")
    @KeyIri(value="http://www.example.org/predicate")
    public Map<Node, PredicateStats> getPredicateStats();

    @Iri(value="http://www.example.org/predicateStats")
    public Set<PredicateStats> getStats();

    default public Stream<PredicateStats> find(Node p) {
        boolean isPredicateComplete = Optional.ofNullable(this.isPredicateComplete()).orElse(false);
        Map<Node, PredicateStats> predMap = this.getPredicateStats();
        Stream<PredicateStats> result = NodeUtils.isNullOrAny((Node)p) ? (isPredicateComplete ? predMap.values().stream() : null) : Stream.ofNullable(predMap.get(p));
        return result;
    }
}

