/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.collection.observable;

import com.google.common.collect.Sets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.aksw.commons.collection.observable.CollectionChangedEventImpl;
import org.aksw.commons.collection.observable.Registration;
import org.aksw.jena_sparql_api.collection.observable.ObservableGraph;
import org.aksw.jena_sparql_api.collection.observable.QuadAction;
import org.aksw.jena_sparql_api.collection.observable.SinglePrefetchClosableIterator;
import org.aksw.jena_sparql_api.rx.GraphFactoryEx;
import org.aksw.jenax.arq.util.triple.SetFromGraph;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphUtil;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.compose.Difference;
import org.apache.jena.graph.compose.Union;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.graph.GraphWrapper;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class ObservableGraphImpl
extends GraphWrapper
implements ObservableGraph {
    protected boolean CheckFirst = true;
    protected boolean RecordNoAction = true;
    protected VetoableChangeSupport vcs = new VetoableChangeSupport(this);
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private static int SLICE = 1000;

    public static ObservableGraphImpl decorate(Graph delegate) {
        return new ObservableGraphImpl(delegate);
    }

    public ObservableGraphImpl(Graph delegate) {
        super(delegate);
    }

    @Override
    public boolean delta(Collection<? extends Triple> rawAdditions, Collection<?> rawDeletions) {
        return ObservableGraphImpl.applyDeltaGraph(this, this.get(), this.vcs, this.pcs, false, rawAdditions, rawDeletions);
    }

    public static boolean applyDeltaGraph(Graph self, Graph backend, VetoableChangeSupport vcs, PropertyChangeSupport pcs, boolean clearIntersection, Collection<? extends Triple> rawAdditions, Collection<?> rawRemovals) {
        boolean changeByRemoval;
        LinkedHashSet rs;
        Set as;
        SetFromGraph backendAsSet = SetFromGraph.wrap((Graph)backend);
        LinkedHashSet physRemovals = rawRemovals == self ? (LinkedHashSet)rawRemovals.stream().map(x -> (Triple)x).collect(Collectors.toCollection(LinkedHashSet::new)) : (Set)rawRemovals.stream().filter(((Set)backendAsSet)::contains).map(x -> (Triple)x).collect(Collectors.toCollection(LinkedHashSet::new));
        Set physAdditions = rawAdditions.stream().filter(x -> !backend.contains(x) || physRemovals.contains(x)).collect(Collectors.toCollection(LinkedHashSet::new));
        LinkedHashSet intersection = new LinkedHashSet(Sets.intersection((Set)physAdditions, (Set)physRemovals));
        if (clearIntersection || intersection.isEmpty()) {
            physRemovals.removeAll(intersection);
            physAdditions.removeAll(intersection);
            as = physAdditions;
            rs = physRemovals;
        } else {
            as = new LinkedHashSet(physAdditions);
            rs = new LinkedHashSet(physRemovals);
            as.removeAll(intersection);
            rs.removeAll(intersection);
        }
        Graph gas = GraphFactory.createDefaultGraph();
        Graph grs = GraphFactory.createDefaultGraph();
        GraphUtil.add((Graph)gas, as.iterator());
        GraphUtil.add((Graph)grs, rs.iterator());
        boolean result = false;
        Graph oldValue = self;
        Graph newValue = rawRemovals == self ? gas : new Union((Graph)new Difference(backend, grs), gas);
        try {
            vcs.fireVetoableChange((PropertyChangeEvent)new CollectionChangedEventImpl((Object)self, (Object)oldValue, (Object)newValue, as, rs, Collections.emptySet()));
        }
        catch (PropertyVetoException e) {
            throw new RuntimeException(e);
        }
        if (rawRemovals == self) {
            boolean bl = changeByRemoval = !backend.isEmpty();
            if (changeByRemoval) {
                backend.clear();
            }
        } else {
            changeByRemoval = backendAsSet.removeAll(physRemovals);
        }
        boolean changeByAddition = backendAsSet.addAll(physAdditions);
        result = changeByRemoval || changeByAddition;
        Graph oldValue2 = rawRemovals == self ? grs : new Union((Graph)new Difference(backend, gas), grs);
        Graph newValue2 = self;
        pcs.firePropertyChange((PropertyChangeEvent)new CollectionChangedEventImpl((Object)self, (Object)oldValue2, (Object)newValue2, as, rs, Collections.emptySet()));
        return result;
    }

    public void add(Triple quad) {
        if (this.CheckFirst && this.contains(quad)) {
            return;
        }
        this.add$(quad);
    }

    private void add$(Triple quad) {
        this.recordVetoable(QuadAction.ADD, quad);
        super.add(quad);
        this.record(QuadAction.ADD, quad);
    }

    public void delete(Triple quad) {
        if (this.CheckFirst && !this.contains(quad)) {
            return;
        }
        this.delete$(quad);
    }

    private void delete$(Triple quad) {
        this.recordVetoable(QuadAction.DELETE, quad);
        super.delete(quad);
        this.record(QuadAction.DELETE, quad);
    }

    public void remove(Node s, Node p, Node o) {
        ObservableGraphImpl.deleteAny(this, Triple.createMatch((Node)s, (Node)p, (Node)o), this.pcs);
    }

    public static void deleteAny(Graph graph, Triple pattern, PropertyChangeSupport pcs) {
        int n;
        do {
            ExtendedIterator iter = graph.find(pattern);
            Graph deletions = GraphFactoryEx.createInsertOrderPreservingGraph();
            n = 0;
            while (n < SLICE & iter.hasNext()) {
                Triple t = (Triple)iter.next();
                deletions.add(t);
                ++n;
            }
            pcs.firePropertyChange((PropertyChangeEvent)new CollectionChangedEventImpl((Object)graph, (Object)graph, (Object)new Difference(graph, deletions), Collections.emptySet(), (Collection)new SetFromGraph(deletions), null));
        } while (n >= SLICE);
    }

    private void recordVetoable(QuadAction action, Triple t) {
        switch (action) {
            case ADD: {
                Set<Triple> additions = Collections.singleton(t);
                Set deletions = Collections.emptySet();
                Graph tmp = GraphFactory.createDefaultGraph();
                tmp.add(t);
                try {
                    this.vcs.fireVetoableChange((PropertyChangeEvent)new CollectionChangedEventImpl((Object)this, (Object)this, (Object)new Union((Graph)this, tmp), additions, deletions, null));
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            case DELETE: {
                Set additions = Collections.emptySet();
                Set<Triple> deletions = Collections.singleton(t);
                Graph tmp = GraphFactory.createDefaultGraph();
                tmp.add(t);
                try {
                    this.vcs.fireVetoableChange((PropertyChangeEvent)new CollectionChangedEventImpl((Object)this, (Object)this, (Object)new Difference((Graph)this, tmp), additions, deletions, null));
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private void record(QuadAction action, Triple t) {
        switch (action) {
            case ADD: {
                Set<Triple> additions = Collections.singleton(t);
                Set deletions = Collections.emptySet();
                Graph tmp = GraphFactory.createDefaultGraph();
                tmp.add(t);
                this.pcs.firePropertyChange((PropertyChangeEvent)new CollectionChangedEventImpl((Object)this, (Object)new Difference((Graph)this, tmp), (Object)this, additions, deletions, Collections.emptySet()));
                break;
            }
            case DELETE: {
                Set additions = Collections.emptySet();
                Set<Triple> deletions = Collections.singleton(t);
                Graph tmp = GraphFactory.createDefaultGraph();
                tmp.add(t);
                this.pcs.firePropertyChange((PropertyChangeEvent)new CollectionChangedEventImpl((Object)this, (Object)new Union((Graph)this, tmp), (Object)this, additions, deletions, Collections.emptySet()));
                break;
            }
        }
    }

    @Override
    public Runnable addVetoableChangeListener(VetoableChangeListener listener) {
        this.vcs.addVetoableChangeListener(listener);
        return () -> this.vcs.removeVetoableChangeListener(listener);
    }

    @Override
    public Registration addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
        return Registration.from(() -> listener.propertyChange((PropertyChangeEvent)new CollectionChangedEventImpl((Object)this, (Object)this, (Object)this, Collections.emptySet(), Collections.emptySet(), Collections.emptySet())), () -> this.pcs.removePropertyChangeListener(listener));
    }

    public ExtendedIterator<Triple> find(Node s, Node p, Node o) {
        final ExtendedIterator it = super.find(s, p, o);
        return WrappedIterator.create((Iterator)((Object)new SinglePrefetchClosableIterator<Triple>(){

            protected Triple prefetch() throws Exception {
                Triple result = it.hasNext() ? (Triple)it.next() : (Triple)this.finish();
                return result;
            }

            protected void doRemove(Triple item) {
                ObservableGraphImpl.this.recordVetoable(QuadAction.DELETE, item);
                it.remove();
                ObservableGraphImpl.this.record(QuadAction.DELETE, item);
            }

            public void close() {
                it.close();
            }
        }));
    }
}

