/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.aksw.commons.rx.lookup.ListService;
import org.aksw.commons.rx.lookup.ListServiceFromList;
import org.aksw.commons.rx.lookup.MapService;
import org.aksw.commons.rx.lookup.MapServiceFromListService;
import org.aksw.commons.util.range.RangeUtils;
import org.aksw.jena_sparql_api.entity.graph.metamodel.ResourceState;
import org.aksw.jena_sparql_api.lookup.MapServiceSparqlQuery;
import org.aksw.jena_sparql_api.schema.NodeSchema;
import org.aksw.jena_sparql_api.schema.PropertySchema;
import org.aksw.jena_sparql_api.schema.ResourceCache;
import org.aksw.jena_sparql_api.schema.ShapedNode;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.arq.util.var.Vars;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactoryQuery;
import org.aksw.jenax.sparql.fragment.api.Fragment1;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.syntax.Element;

public class ShapedProperty {
    protected ShapedNode src;
    protected Path path;
    protected Collection<PropertySchema> propertySchemas;

    public ShapedProperty(ShapedNode src, Path path) {
        this(path, new ArrayList<PropertySchema>());
        this.src = src;
    }

    public Path getPath() {
        return this.path;
    }

    public ShapedProperty(Path path, Collection<PropertySchema> propertySchemas) {
        this.path = path;
        this.propertySchemas = propertySchemas;
    }

    public void addShape(PropertySchema propertySchema) {
        this.propertySchemas.add(propertySchema);
    }

    protected ShapedNode createTargetShapedNode(Node tgt, Collection<NodeSchema> nodeSchemas) {
        return ShapedNode.create(tgt, nodeSchemas, this.src.getResourceCache(), this.src.getConnection());
    }

    protected Set<Node> getCachedValues() {
        ResourceCache resourceCache = this.src.getResourceCache();
        ResourceState rs = resourceCache.get(this.src.getSourceNode());
        Set<Node> cachedValues = rs == null ? null : rs.getFromCache(this.path);
        return null;
    }

    protected boolean isInMemory() {
        boolean result = this.getCachedValues() != null;
        return result;
    }

    public boolean isEmpty() {
        Set<Node> cachedValues = this.getCachedValues();
        boolean result = cachedValues != null ? cachedValues.isEmpty() : ((Boolean)this.getValues().streamData(null, RangeUtils.rangeStartingWithZero).isEmpty().blockingGet()).booleanValue();
        return result;
    }

    public MapService<Fragment1, Node, ShapedNode> getValues() {
        MapServiceFromListService core;
        ResourceCache resourceCache = this.src.getResourceCache();
        Set<Node> cachedValues = this.getCachedValues();
        QueryExecutionFactoryQuery conn = this.src.getConnection();
        Set<NodeSchema> tgtNodeSchemas = this.getTargetNodeSchemas();
        if (cachedValues != null) {
            ArrayList<Node> items = new ArrayList<Node>(cachedValues);
            ListService listService = ListServiceFromList.wrap(items, (a, b) -> true);
            core = new MapServiceFromListService(listService, n -> n, n -> {
                Table table = null;
                return table;
            });
        } else {
            TriplePath tp = new TriplePath(this.src.getSourceNode(), this.path, (Node)Vars.o);
            Query query = new Query();
            query.setQuerySelectType();
            query.getProject().add(Vars.o);
            query.setQueryPattern((Element)ElementUtils.createElement((TriplePath)tp));
            core = new MapServiceSparqlQuery(this.src.getConnection(), query, Vars.o);
        }
        MapService result = core.transformValues((k, v) -> {
            ShapedNode r = ShapedNode.create(k, tgtNodeSchemas, resourceCache, conn);
            return r;
        });
        return result;
    }

    public Set<NodeSchema> getTargetNodeSchemas() {
        Set<NodeSchema> tgtNodeSchemas = this.propertySchemas.stream().map(PropertySchema::getTargetSchemas).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet());
        return tgtNodeSchemas;
    }
}

