/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.collection.observable;

import com.google.common.base.Converter;
import org.aksw.commons.collection.observable.ObservableCollection;
import org.aksw.commons.collection.observable.ObservableConvertingCollection;
import org.aksw.jena_sparql_api.collection.observable.ObservableGraph;
import org.aksw.jena_sparql_api.collection.observable.ObservableSetFromGraph;
import org.aksw.jena_sparql_api.collection.observable.ObservableSubGraph;
import org.aksw.jena_sparql_api.relation.ConverterTripleToNode;
import org.aksw.jenax.arq.util.triple.TripleFilter;
import org.apache.jena.graph.Node;

public class SetOfNodesFromGraph {
    public static ObservableCollection<Node> create(ObservableGraph graph, TripleFilter dftp) {
        Node source = dftp.getSource();
        Node predicate = dftp.getTriplePattern().getPredicate();
        boolean isForward = dftp.isForward();
        ObservableSubGraph subGraph = ObservableSubGraph.decorate(graph, dftp.toConstraint());
        ConverterTripleToNode converter = new ConverterTripleToNode(source, predicate, isForward);
        ObservableSetFromGraph tripleSet = new ObservableSetFromGraph(subGraph);
        ObservableConvertingCollection nodeSet = new ObservableConvertingCollection((ObservableCollection)tripleSet, (Converter)converter);
        return nodeSet;
    }

    public static ObservableCollection<Node> create(ObservableGraph graph, Node sourceNode, Node predicate, boolean isForward) {
        TripleFilter dftp = TripleFilter.create((Node)sourceNode, (Node)predicate, (boolean)isForward);
        return SetOfNodesFromGraph.create(graph, dftp);
    }
}

