/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.schema;

import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Stream;
import org.aksw.jena_sparql_api.schema.NodeSchema;
import org.aksw.jena_sparql_api.schema.PropertySchema;
import org.aksw.jenax.arq.util.triple.TripleUtils;
import org.aksw.jenax.arq.util.var.Vars;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.P_ReverseLink;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.util.iterator.ExtendedIterator;

public class PropertySchemaImpl
implements PropertySchema {
    protected Node predicate;
    protected boolean isForward;
    protected Set<NodeSchema> targetSchemas;

    public PropertySchemaImpl(Node predicate, boolean isForward) {
        this.predicate = predicate;
        this.isForward = isForward;
        this.targetSchemas = new HashSet<NodeSchema>();
    }

    @Override
    public Node getPredicate() {
        return this.predicate;
    }

    @Override
    public boolean isForward() {
        return this.isForward;
    }

    public Set<NodeSchema> getTargetSchemas() {
        return this.targetSchemas;
    }

    @Override
    public boolean canMatchTriples() {
        return true;
    }

    @Override
    public boolean matchesTriple(Node source, Triple triple) {
        Triple matcher = TripleUtils.create((Node)source, (Node)this.predicate, (Node)Vars.o, (boolean)this.isForward);
        boolean result = matcher.matches(triple);
        return result;
    }

    @Override
    public long copyMatchingValues(Node source, Collection<Node> target, Graph sourceGraph) {
        long result = this.streamMatchingTriples(source, sourceGraph).map(t -> TripleUtils.getTarget((Triple)t, (boolean)this.isForward)).peek(target::add).count();
        return result;
    }

    @Override
    public Stream<Triple> streamMatchingTriples(Node source, Graph sourceGraph) {
        Triple matcher = TripleUtils.create((Node)source, (Node)this.predicate, (Node)Vars.o, (boolean)this.isForward);
        ExtendedIterator it = sourceGraph.find(matcher);
        Stream result = Streams.stream((Iterator)it);
        return result;
    }

    @Override
    public long copyMatchingTriples(Node source, Graph targetGraph, Graph sourceGraph) {
        long result = this.streamMatchingTriples(source, sourceGraph).peek(arg_0 -> ((Graph)targetGraph).add(arg_0)).count();
        return result;
    }

    @Override
    public Path getPath() {
        return this.isForward ? new P_Link(this.predicate) : new P_ReverseLink(this.predicate);
    }
}

