/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.entity.graph.metamodel;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import java.nio.charset.StandardCharsets;
import org.aksw.jena_sparql_api.entity.graph.metamodel.ClassRelationModel;
import org.aksw.jena_sparql_api.entity.graph.metamodel.ConceptManager;
import org.aksw.jenax.sparql.fragment.api.Fragment1;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.rdf.model.ModelFactory;

public class ConceptManagerImpl
implements ConceptManager {
    protected ClassRelationModel classModel = (ClassRelationModel)ModelFactory.createDefaultModel().createResource().as(ClassRelationModel.class);

    @Override
    public Node getOrCreate(Fragment1 concept) {
        String queryStr = concept.toQuery().toString();
        HashCode hashCode = Hashing.sha256().hashString((CharSequence)queryStr, StandardCharsets.UTF_8);
        String hashStr = BaseEncoding.base64Url().omitPadding().encode(hashCode.asBytes());
        Node node = NodeFactory.createURI((String)("urn:" + hashStr));
        ClassRelationModel result = this.classModel.getClassModel().computeIfAbsent(node, n -> {
            ClassRelationModel r = (ClassRelationModel)this.classModel.getModel().createResource().as(ClassRelationModel.class);
            r.setExpression(queryStr);
            return r;
        });
        System.out.println(result.getExpression());
        return result.asNode();
    }
}

