/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.shape;

import java.util.List;
import java.util.Map;
import org.aksw.jena_sparql_api.shape.ResourceShape;
import org.aksw.jena_sparql_api.shape.ResourceShapeBuilder;
import org.aksw.jena_sparql_api.shape.StepRelation;
import org.aksw.jenax.arq.util.var.Vars;
import org.aksw.jenax.sparql.fragment.api.Fragment2;
import org.aksw.jenax.sparql.fragment.impl.Fragment2Impl;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.util.ExprUtils;

public class ResourceShapeParserJsonObject {
    public static final String geo = "http://www.w3.org/2003/01/geo/wgs84_pos#";
    public static final String geom = "http://geovocab.org/geometry#";
    public static final String ogc = "http://www.opengis.net/ont/geosparql#asWKT";
    public static final String wgs84 = "['geo:lat', 'geo:long']";
    public static final String wgs84geometry = "['geo:geometry']";
    public static final String geoSparqlLgd = "[geom:geometry: 'ogc:AsWkt']";
    private PrefixMapping prefixMapping;

    public ResourceShapeParserJsonObject(PrefixMapping prefixMapping) {
        this.prefixMapping = prefixMapping;
    }

    public static StepRelation parseStep(String str, PrefixMapping prefixMapping) {
        Expr expr;
        boolean isExpr;
        boolean isInverse;
        char c = (str = str.trim()).charAt(0);
        boolean bl = isInverse = c == '-';
        if (isInverse) {
            str = str.substring(1);
        }
        boolean bl2 = isExpr = (c = str.charAt(0)) == '~';
        if (isExpr) {
            str = str.substring(1);
        }
        if (isExpr) {
            expr = ExprUtils.parse((String)str, (PrefixMapping)prefixMapping);
        } else {
            String p = prefixMapping.expandPrefix(str);
            Node np = NodeFactory.createURI((String)p);
            expr = new E_Equals((Expr)new ExprVar(Vars.p), (Expr)NodeValue.makeNode((Node)np));
        }
        Fragment2Impl relation = new Fragment2Impl((Element)new ElementFilter(expr), Vars.p, Vars.o);
        StepRelation result = new StepRelation((Fragment2)relation, isInverse);
        return result;
    }

    public ResourceShape parse(Object obj) {
        ResourceShapeBuilder builder = new ResourceShapeBuilder(this.prefixMapping);
        this.parse(obj, builder);
        ResourceShape result = builder.getResourceShape();
        return result;
    }

    public ResourceShape parse(Object obj, ResourceShapeBuilder builder) {
        if (obj == null) {
            // empty if block
        }
        if (obj instanceof Boolean) {
            Boolean tf = (Boolean)obj;
            if (tf.booleanValue()) {
                builder.nav((Expr)NodeValue.TRUE, true);
            }
        } else if (obj instanceof String) {
            String str = (String)obj;
            StepRelation step = ResourceShapeParserJsonObject.parseStep(str, this.prefixMapping);
            builder.nav(step);
        } else if (obj instanceof List) {
            List list = (List)obj;
            for (Object item : list) {
                this.parse(item, builder);
            }
        } else if (obj instanceof Map) {
            Map map = (Map)obj;
            for (Map.Entry entry : map.entrySet()) {
                String str = (String)entry.getKey();
                Object o = entry.getValue();
                StepRelation step = ResourceShapeParserJsonObject.parseStep(str, this.prefixMapping);
                ResourceShapeBuilder subBilder = builder.nav(step);
                this.parse(o, subBilder);
            }
        } else {
            throw new RuntimeException("Unsupported argument: " + String.valueOf(obj));
        }
        return null;
    }
}

