/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.collection.observable;

import org.aksw.commons.collection.observable.ObservableCollection;
import org.aksw.jena_sparql_api.schema.PropertySchema;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;

public interface RdfField {
    public PropertySchema getPropertySchema();

    public Node getSourceNode();

    public boolean isIntensional();

    public void setIntensional(boolean var1);

    public void setDeleted(boolean var1);

    public boolean isDeleted();

    public ObservableCollection<Node> getAddedAsSet();

    public ObservableCollection<Node> getEffectiveAsSet();

    default public boolean matchesTriple(Triple t) {
        PropertySchema schema = this.getPropertySchema();
        if (!schema.canMatchTriples()) {
            throw new RuntimeException("Schema does not support matching triples");
        }
        Node sourceNode = this.getSourceNode();
        boolean result = schema.matchesTriple(sourceNode, t);
        return result;
    }
}

