/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.collection.observable;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aksw.commons.collection.observable.ObservableCollection;
import org.aksw.commons.collection.observable.ObservableMap;
import org.aksw.commons.collection.observable.ObservableMapImpl;
import org.aksw.commons.collection.observable.ObservableSet;
import org.aksw.commons.collection.observable.ObservableValue;
import org.aksw.commons.collection.observable.ObservableValueFromObservableCollection;
import org.aksw.jena_sparql_api.collection.observable.GraphChange;
import org.aksw.jena_sparql_api.collection.observable.ObservableGraph;
import org.aksw.jena_sparql_api.collection.observable.ObservableGraphImpl;
import org.aksw.jena_sparql_api.collection.observable.RdfField;
import org.aksw.jena_sparql_api.collection.observable.SetOfNodesFromGraph;
import org.aksw.jenax.arq.util.triple.SetFromGraph;
import org.aksw.jenax.arq.util.triple.TripleFilter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.GraphBase;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.graph.NodeTransformLib;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class GraphChangeWithBaseGraph
extends GraphChange {
    protected ObservableGraph baseGraph;

    public GraphChangeWithBaseGraph() {
        this((ObservableMap<Node, Node>)ObservableMapImpl.decorate(new HashMap()), (ObservableMap<Triple, Triple>)ObservableMapImpl.decorate(new HashMap()), ObservableGraphImpl.decorate(GraphFactory.createPlainGraph()));
    }

    public GraphChangeWithBaseGraph(ObservableMap<Node, Node> renamedNodes, ObservableMap<Triple, Triple> tripleReplacements, ObservableGraph baseGraph) {
        super(renamedNodes, tripleReplacements);
        tripleReplacements.addPropertyChangeListener(ev -> this.refreshDeletions());
        this.additionGraph.addPropertyChangeListener(ev -> this.refreshDeletions());
        this.deletionGraph.addPropertyChangeListener(ev -> this.refreshDeletions());
        renamedNodes.addPropertyChangeListener(ev -> this.refreshDeletions());
        baseGraph.addPropertyChangeListener(ev -> this.refreshDeletions());
    }

    public ObservableGraph getBaseGraph() {
        return this.baseGraph;
    }

    public ObservableCollection<Node> createSetField(Node sourceNode, TripleFilter dftp) {
        ObservableCollection<Node> set = SetOfNodesFromGraph.create(this.baseGraph, dftp);
        return set;
    }

    public ObservableValue<Node> createValueField(Node sourceNode, TripleFilter dftp) {
        ObservableCollection<Node> set = this.createSetField(sourceNode, dftp);
        ObservableValue result = ObservableValueFromObservableCollection.decorate(set);
        return result;
    }

    public Graph getSameAsInferredGraphView() {
        return new GraphBase(){

            protected ExtendedIterator<Triple> graphBaseFind(Triple triplePattern) {
                HashMap<Node, Node> nodeToCluster = new HashMap<Node, Node>((Map<Node, Node>)GraphChangeWithBaseGraph.this.renamedNodes);
                for (Node v : GraphChangeWithBaseGraph.this.renamedNodes.values()) {
                    Node newV = (Node)GraphChangeWithBaseGraph.this.renamedNodes.get((Object)v);
                    if (newV != null) continue;
                    nodeToCluster.put(v, v);
                }
                Multimap clusterToMembers = (Multimap)nodeToCluster.entrySet().stream().collect(Multimaps.toMultimap(Map.Entry::getValue, Map.Entry::getKey, HashMultimap::create));
                Stream<Object> expandedLookups = GraphChange.expand(triplePattern, Triple.createMatch(null, null, null), node -> clusterToMembers.get((Object)((Node)nodeToCluster.get(node))));
                List tmpX = expandedLookups.collect(Collectors.toList());
                expandedLookups = tmpX.stream();
                Stream rawTriples = expandedLookups.flatMap(pattern -> Streams.stream((Iterator)GraphChangeWithBaseGraph.this.baseGraph.find((Triple)pattern)));
                Stream<Object> stream = rawTriples.flatMap(triple -> {
                    Triple replacement;
                    boolean isRemapped = GraphChangeWithBaseGraph.this.tripleReplacements.containsKey(triple);
                    Stream<Object> r = isRemapped ? ((replacement = (Triple)GraphChangeWithBaseGraph.this.tripleReplacements.get(triple)) == null ? Stream.empty() : Stream.of(replacement)) : Stream.of(triple);
                    return r;
                }).flatMap(triple -> GraphChange.expand(triple, triplePattern, node -> clusterToMembers.get((Object)((Node)nodeToCluster.get(node)))));
                List tmp = stream.collect(Collectors.toList());
                stream = tmp.stream();
                ExtendedIterator result = WrappedIterator.create(stream.iterator());
                return result;
            }
        };
    }

    protected void refreshDeletions() {
        Set<Object> additions = new LinkedHashSet();
        LinkedHashSet<Triple> deletions = new LinkedHashSet<Triple>();
        this.deletionGraph.find().forEachRemaining(deletions::add);
        ExtendedIterator itTriple = this.baseGraph.find();
        while (itTriple.hasNext()) {
            Triple t2 = (Triple)itTriple.next();
            for (RdfField field : this.sourceNodeToField.values()) {
                if (!field.isIntensional() || !field.isDeleted() || !field.matchesTriple(t2)) continue;
                deletions.add(t2);
            }
        }
        ObservableSet keys = this.tripleReplacements.keySet();
        deletions.addAll((Collection<Triple>)keys);
        HashSet valueSet = new HashSet(this.tripleReplacements.values());
        deletions.removeAll(valueSet);
        this.additionGraph.find().forEachRemaining(additions::add);
        valueSet.stream().filter(item -> item != null && !this.baseGraph.contains((Triple)item)).forEach(additions::add);
        NodeTransform xform = n -> {
            Node r = (Node)this.renamedNodes.get(n);
            return r == null ? n : r;
        };
        additions = additions.stream().map(t -> NodeTransformLib.transform((NodeTransform)xform, (Triple)t)).collect(Collectors.toSet());
        GraphChangeWithBaseGraph.makeSetEqual(new SetFromGraph((Graph)this.effectiveDeletionGraph), deletions);
        GraphChangeWithBaseGraph.makeSetEqual(new SetFromGraph((Graph)this.effectiveAdditionGraph), additions);
    }

    public ObservableCollection<Node> createSetForPredicate(Node source, Node predicate, boolean isForward) {
        TripleFilter dftp = TripleFilter.create((Node)source, (Node)predicate, (boolean)isForward);
        return this.createSetField(source, dftp);
    }
}

