/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.schema;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aksw.jena_sparql_api.schema.NodeSchema;
import org.aksw.jena_sparql_api.schema.PropertySchemaFromPropertyShape;
import org.aksw.jenax.annotation.reprogen.Iri;
import org.aksw.jenax.annotation.reprogen.ResourceView;
import org.aksw.jenax.arq.util.triple.TripleFilter;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.impl.ModelCom;
import org.apache.jena.rdf.model.impl.PropertyImpl;
import org.topbraid.shacl.model.SHNodeShape;
import org.topbraid.shacl.model.SHPropertyShape;
import org.topbraid.shacl.vocabulary.SH;

@ResourceView
public interface NodeSchemaFromNodeShape
extends NodeSchema,
Resource {
    default public SHNodeShape getNodeShape() {
        return (SHNodeShape)this.as(SHNodeShape.class);
    }

    @Iri(value="http://www.w3.org/ns/shacl#targetClass")
    public Resource getTargetClass();

    public NodeSchemaFromNodeShape setTargetClass(Resource var1);

    default public Stream<PropertySchemaFromPropertyShape> getPropertySchemas(Node predicate, boolean isForward) {
        return this.getPredicateSchemas().stream().filter(item -> Objects.equals(item.getPredicate(), predicate) && item.isForward() == isForward);
    }

    @Override
    default public PropertySchemaFromPropertyShape createPropertySchema(Node predicate, boolean isForward) {
        PropertySchemaFromPropertyShape result;
        Set set = this.getPropertySchemas(predicate, isForward).collect(Collectors.toSet());
        PropertySchemaFromPropertyShape propertySchemaFromPropertyShape = result = set.isEmpty() ? null : (PropertySchemaFromPropertyShape)Iterables.getOnlyElement(set);
        if (result == null) {
            SHNodeShape nodeShape = this.getNodeShape();
            Model m = nodeShape.getModel();
            SHPropertyShape propertyShape = (SHPropertyShape)m.createResource().as(SHPropertyShape.class);
            PropertyImpl p = new PropertyImpl(predicate, (EnhGraph)((ModelCom)m));
            PropertyImpl path = isForward ? p : m.createResource().addProperty(SH.inversePath, (RDFNode)p);
            propertyShape.addProperty(SH.path, (RDFNode)path);
            nodeShape.addProperty(SH.property, (RDFNode)propertyShape);
            result = (PropertySchemaFromPropertyShape)propertyShape.as(PropertySchemaFromPropertyShape.class);
        }
        return result;
    }

    @Override
    default public Set<TripleFilter> getGenericPatterns() {
        return Collections.emptySet();
    }

    default public List<PropertySchemaFromPropertyShape> getPredicateSchemas() {
        SHNodeShape nodeShape = this.getNodeShape();
        List<PropertySchemaFromPropertyShape> result = nodeShape.getPropertyShapes().stream().map(propertyShape -> (PropertySchemaFromPropertyShape)propertyShape.as(PropertySchemaFromPropertyShape.class)).collect(Collectors.toList());
        return result;
    }
}

