/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.entity.graph.metamodel;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.aksw.jena_sparql_api.entity.graph.metamodel.PredicateStats;
import org.aksw.jena_sparql_api.entity.graph.metamodel.ResourceGraphMetamodel;
import org.aksw.jenax.annotation.reprogen.HashId;
import org.aksw.jenax.annotation.reprogen.Iri;
import org.aksw.jenax.annotation.reprogen.IriNs;
import org.aksw.jenax.annotation.reprogen.IriType;
import org.aksw.jenax.annotation.reprogen.KeyIri;
import org.aksw.jenax.annotation.reprogen.ResourceView;
import org.aksw.jenax.arq.util.node.NodeUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.rdf.model.Resource;

@HashId
@ResourceView
public interface ResourceMetamodel
extends Resource {
    @IriNs(value="eg")
    public Resource getTargetResource();

    @HashId
    @IriType
    @IriNs(value="eg")
    public String getTargetResourceIri();

    @IriNs(value="eg")
    @KeyIri(value="http://www.example.org/graph")
    public Map<Node, ResourceGraphMetamodel> byGraph();

    @Iri(value="http://www.example.org/byGraph")
    public Set<ResourceGraphMetamodel> byGraphs();

    @IriNs(value="eg")
    public Boolean isGraphComplete();

    default public ResourceGraphMetamodel getOrCreateResourceMetamodel(String iri) {
        return this.getOrCreateResourceMetamodel(NodeFactory.createURI((String)iri));
    }

    default public ResourceGraphMetamodel getOrCreateResourceMetamodel(Node key) {
        ResourceGraphMetamodel result = this.byGraph().computeIfAbsent(key, k -> (ResourceGraphMetamodel)this.getModel().createResource().as(ResourceGraphMetamodel.class));
        return result;
    }

    default public Stream<PredicateStats> find(Node g, boolean isFwd, Node p) {
        boolean isGraphComplete = Optional.ofNullable(this.isGraphComplete()).orElse(false);
        Map<Node, ResourceGraphMetamodel> graphMap = this.byGraph();
        Stream<ResourceGraphMetamodel> gs = NodeUtils.isNullOrAny((Node)g) ? (isGraphComplete ? graphMap.values().stream() : null) : Stream.ofNullable(graphMap.get(g));
        Stream<PredicateStats> result = gs.flatMap(gm -> gm.find(isFwd, p));
        return result;
    }
}

