/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.collection.observable;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aksw.commons.collection.observable.ObservableMap;
import org.aksw.commons.collection.observable.ObservableMapImpl;
import org.aksw.commons.collection.observable.ObservableSet;
import org.aksw.commons.collection.observable.ObservableSetImpl;
import org.aksw.commons.collection.observable.ObservableValue;
import org.aksw.commons.collections.CartesianProduct;
import org.aksw.commons.collections.SetUtils;
import org.aksw.jena_sparql_api.collection.observable.ObservableGraph;
import org.aksw.jena_sparql_api.collection.observable.ObservableGraphImpl;
import org.aksw.jena_sparql_api.collection.observable.RdfField;
import org.aksw.jena_sparql_api.collection.observable.RdfFieldForSubGraph;
import org.aksw.jena_sparql_api.collection.observable.RdfFieldFromExistingTriple;
import org.aksw.jenax.arq.util.node.NodeTransformRenameMap;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.arq.util.triple.TripleFilter;
import org.aksw.jenax.arq.util.triple.TripleUtils;
import org.aksw.jenax.arq.util.var.Vars;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphUtil;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.compose.Delta;
import org.apache.jena.graph.impl.GraphBase;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.algebra.TableFactory;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.graph.NodeTransformLib;
import org.apache.jena.sparql.modify.request.QuadDataAcc;
import org.apache.jena.sparql.modify.request.UpdateDataDelete;
import org.apache.jena.sparql.modify.request.UpdateDataInsert;
import org.apache.jena.sparql.modify.request.UpdateDeleteInsert;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementData;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.update.Update;
import org.apache.jena.update.UpdateRequest;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class GraphChange {
    protected ObservableMap<Node, Node> renamedNodes;
    protected ObservableMap<Triple, Triple> tripleReplacements;
    protected Multimap<Node, RdfField> sourceNodeToField = HashMultimap.create();
    protected ObservableGraph additionGraph;
    protected ObservableGraph deletionGraph;
    protected ObservableGraph effectiveDeletionGraph;
    protected ObservableGraph effectiveAdditionGraph;
    protected ObservableSet<Node> newNodes = new ObservableSetImpl(new LinkedHashSet());
    protected PropertyChangeSupport pce = new PropertyChangeSupport(this);

    public ObservableSet<Node> getNewNodes() {
        return this.newNodes;
    }

    public Node freshNode() {
        Node result = NodeFactory.createBlankNode();
        this.newNodes.add((Object)result);
        return result;
    }

    public GraphChange() {
        this((ObservableMap<Node, Node>)ObservableMapImpl.decorate(new HashMap()), (ObservableMap<Triple, Triple>)ObservableMapImpl.decorate(new HashMap()));
    }

    public GraphChange(ObservableMap<Node, Node> renamedNodes, ObservableMap<Triple, Triple> tripleReplacements) {
        this.renamedNodes = renamedNodes;
        this.tripleReplacements = tripleReplacements;
        this.additionGraph = ObservableGraphImpl.decorate(GraphFactory.createDefaultGraph());
        this.deletionGraph = ObservableGraphImpl.decorate(GraphFactory.createDefaultGraph());
        this.effectiveAdditionGraph = ObservableGraphImpl.decorate(GraphFactory.createDefaultGraph());
        this.effectiveDeletionGraph = ObservableGraphImpl.decorate(GraphFactory.createDefaultGraph());
    }

    public GraphChange putRename(Node before, Node after) {
        ObservableMap<Node, Node> renames = this.getRenamedNodes();
        if (Objects.equals(before, after)) {
            renames.remove(before);
        } else {
            renames.put(before, after);
        }
        return this;
    }

    public ObservableGraph getEffectiveAdditionGraph() {
        return this.effectiveAdditionGraph;
    }

    public ObservableGraph getEffectiveDeletionGraph() {
        return this.effectiveDeletionGraph;
    }

    public boolean isDeleted(Triple triple) {
        for (int i = 0; i < 2; ++i) {
            Node sourceNode = i == 0 ? triple.getSubject() : triple.getObject();
            boolean fwd = i == 0;
            this.sourceNodeToField.get((Object)sourceNode).stream().filter(field -> field.getSourceNode().equals((Object)sourceNode) && field.getPropertySchema().isForward() == fwd);
        }
        return false;
    }

    public Runnable addPropertyChangeListener(PropertyChangeListener listener) {
        this.pce.addPropertyChangeListener(listener);
        return () -> this.pce.removePropertyChangeListener(listener);
    }

    public ObservableValue<Node> createFieldForExistingTriple(Triple baseTriple, int componentIdx) {
        return new RdfFieldFromExistingTriple(this, baseTriple, componentIdx);
    }

    public RdfField createSetField(Node sourceNode, Node predicate, boolean isForward) {
        TripleFilter dftp = TripleFilter.create((Node)sourceNode, (Node)predicate, (boolean)isForward);
        RdfFieldForSubGraph result = new RdfFieldForSubGraph(this, dftp);
        return result;
    }

    public ObservableMap<Triple, Triple> getTripleReplacements() {
        return this.tripleReplacements;
    }

    public ObservableMap<Node, Node> getRenamedNodes() {
        return this.renamedNodes;
    }

    public ObservableGraph getAdditionGraph() {
        return this.additionGraph;
    }

    public ObservableGraph getDeletionGraph() {
        return this.deletionGraph;
    }

    public static <T> Collection<T> nullableSingleton(T item) {
        return item == null ? Collections.emptySet() : Collections.singleton(item);
    }

    public static <T> void makeSetEqual(Set<T> target, Set<T> reference) {
        HashSet deletions = new HashSet(Sets.difference(target, reference));
        HashSet additions = new HashSet(Sets.difference(reference, target));
        target.removeAll(deletions);
        target.addAll(additions);
    }

    public static <T> Collection<T> defaultToSingletonIfEmpty(Collection<T> items, T defaultItem) {
        return items.isEmpty() ? Collections.singleton(defaultItem) : items;
    }

    public static <T> Collection<T> filterToPattern(Collection<T> collection, T pattern) {
        return pattern == null ? collection : (collection.contains(pattern) ? Collections.singleton(pattern) : Collections.emptySet());
    }

    public static Collection<Node> filterToPattern(Function<Node, Collection<Node>> fn, Node node, Node pattern) {
        Collection<Node> result;
        boolean isAnyPattern;
        boolean isAnyNode = node == null || Node.ANY.equals((Object)node);
        boolean bl = isAnyPattern = pattern == null || Node.ANY.equals((Object)pattern);
        if (isAnyNode) {
            result = isAnyPattern ? Collections.singleton(Node.ANY) : Collections.singleton(pattern);
        } else {
            result = fn.apply(node);
            if (!isAnyPattern) {
                result = result.contains(pattern) ? Collections.singleton(pattern) : Collections.emptySet();
            }
        }
        return result;
    }

    public static <T> Collection<T> get(Multimap<T, T> multimap, T key, boolean reflexive) {
        Collection result = multimap.get(key);
        result = reflexive ? (result.contains(key) ? result : Sets.union(Collections.singleton(key), (Set)SetUtils.asSet((Iterable)result))) : result;
        return result;
    }

    public static <K, V> V getOrDefault(Function<? super K, ? extends V> fn, K key, V defaultValue) {
        V result = fn.apply(key);
        result = result == null ? defaultValue : result;
        return result;
    }

    public static Stream<Triple> expand(Triple concrete, Triple pattern, Function<Node, Collection<Node>> clusterToMembers) {
        Node cs = concrete.getSubject();
        Node cp = concrete.getPredicate();
        Node co = concrete.getObject();
        CartesianProduct cart = CartesianProduct.create((Iterable[])new Iterable[]{GraphChange.filterToPattern(clusterToMembers, cs, pattern.getMatchSubject()), GraphChange.filterToPattern(clusterToMembers, cp, pattern.getMatchPredicate()), GraphChange.filterToPattern(clusterToMembers, co, pattern.getMatchObject())});
        Stream<Object> result = cart.stream().map(TripleUtils::listToTriple);
        List tmp = result.collect(Collectors.toList());
        result = tmp.stream();
        return result;
    }

    public static Table createTableFromEnties(Var keyVar, Var valueVar, Collection<? extends Map.Entry<? extends Node, ? extends Node>> entrySet) {
        Table result = TableFactory.create(Arrays.asList(keyVar, valueVar));
        for (Map.Entry<? extends Node, ? extends Node> entry : entrySet) {
            Binding binding = BindingFactory.builder().add(keyVar, entry.getKey()).add(valueVar, entry.getValue()).build();
            result.addBinding(binding);
        }
        return result;
    }

    public static UpdateDeleteInsert createUpdateRenameComponent(int componentIdx, Collection<? extends Map.Entry<? extends Node, ? extends Node>> renamedNodes) {
        Node[] nodes = new Node[]{Vars.s, Vars.p, Vars.o};
        Var oldVar = (Var)nodes[componentIdx];
        Var newVar = Vars.x;
        Table renameTable = GraphChange.createTableFromEnties(oldVar, newVar, renamedNodes);
        Triple oldTp = TripleUtils.fromArray((Node[])nodes);
        nodes[componentIdx] = newVar;
        Triple newTp = TripleUtils.fromArray((Node[])nodes);
        Query subQuery = new Query();
        subQuery.setQuerySelectType();
        subQuery.setDistinct(true);
        subQuery.addResultVar((Node)oldVar);
        subQuery.addResultVar((Node)newVar);
        subQuery.setQueryPattern(ElementUtils.groupIfNeeded((Element[])new Element[]{new ElementData(renameTable.getVars(), (List)Lists.newArrayList((Iterator)renameTable.rows())), ElementUtils.createElement((Triple)oldTp)}));
        UpdateDeleteInsert renameUpdate = new UpdateDeleteInsert();
        renameUpdate.getInsertAcc().addTriple(newTp);
        renameUpdate.getDeleteAcc().addTriple(oldTp);
        renameUpdate.setElement((Element)new ElementSubQuery(subQuery));
        return renameUpdate;
    }

    public UpdateRequest toUpdateRequest() {
        Map effectiveRenames;
        Map existingRenames;
        UpdateRequest result = new UpdateRequest();
        if (!this.deletionGraph.isEmpty()) {
            QuadDataAcc acc = new QuadDataAcc();
            this.deletionGraph.find().forEach(arg_0 -> ((QuadDataAcc)acc).addTriple(arg_0));
            result.add((Update)new UpdateDataDelete(acc));
        }
        if (!(existingRenames = Maps.filterKeys((Map)(effectiveRenames = Maps.filterEntries(this.renamedNodes, e -> !Objects.equals(e.getKey(), e.getValue()))), key -> !this.newNodes.contains(key) && !key.isBlank())).isEmpty()) {
            UpdateDeleteInsert renameS = GraphChange.createUpdateRenameComponent(0, existingRenames.entrySet());
            UpdateDeleteInsert renameP = GraphChange.createUpdateRenameComponent(1, existingRenames.entrySet());
            UpdateDeleteInsert renameO = GraphChange.createUpdateRenameComponent(2, existingRenames.entrySet());
            result.add((Update)renameS);
            result.add((Update)renameP);
            result.add((Update)renameO);
        }
        QuadDataAcc postRenameDeletes = new QuadDataAcc();
        QuadDataAcc postRenameInserts = new QuadDataAcc();
        Map effectiveTripleReplacements = Maps.filterEntries(this.tripleReplacements, e -> !Objects.equals(e.getKey(), e.getValue()));
        NodeTransformRenameMap nodeTransform = NodeTransformRenameMap.create((Map)effectiveRenames);
        if (!effectiveTripleReplacements.isEmpty()) {
            for (Map.Entry e2 : this.tripleReplacements.entrySet()) {
                Triple before = (Triple)e2.getKey();
                Triple after = (Triple)e2.getValue();
                Triple toDelete = NodeTransformLib.transform((NodeTransform)nodeTransform, (Triple)before);
                postRenameDeletes.addTriple(toDelete);
                Node[] nodes = new Node[3];
                for (int i = 0; i < 3; ++i) {
                    Node a;
                    Node b = TripleUtils.getNode((Triple)before, (int)i);
                    nodes[i] = Objects.equals(b, a = TripleUtils.getNode((Triple)after, (int)i)) ? effectiveRenames.getOrDefault(b, b) : a;
                }
                Triple toAdd = TripleUtils.fromArray((Node[])nodes);
                postRenameInserts.addTriple(toAdd);
            }
        }
        this.additionGraph.find().mapWith(arg_0 -> GraphChange.lambda$toUpdateRequest$5((NodeTransform)nodeTransform, arg_0)).forEach(arg_0 -> ((QuadDataAcc)postRenameInserts).addTriple(arg_0));
        if (!postRenameDeletes.getQuads().isEmpty()) {
            result.add((Update)new UpdateDataDelete(postRenameDeletes));
        }
        if (!postRenameInserts.getQuads().isEmpty()) {
            result.add((Update)new UpdateDataInsert(postRenameInserts));
        }
        return result;
    }

    public static Graph createEffectiveGraphView(final Graph baseGraph, final GraphChange graphChange) {
        return new GraphBase(){

            protected ExtendedIterator<Triple> graphBaseFind(Triple triplePattern) {
                Delta delta = new Delta(baseGraph);
                GraphUtil.addInto((Graph)delta.getAdditions(), (Graph)graphChange.getAdditionGraph());
                GraphUtil.addInto((Graph)delta.getDeletions(), (Graph)graphChange.getDeletionGraph());
                ObservableMap<Node, Node> renamedNodes = graphChange.getRenamedNodes();
                ObservableMap<Triple, Triple> tripleReplacements = graphChange.getTripleReplacements();
                HashMap<Node, Node> nodeToCluster = new HashMap<Node, Node>((Map<Node, Node>)renamedNodes);
                for (Node v : renamedNodes.values()) {
                    Node newV = (Node)renamedNodes.get((Object)v);
                    if (newV != null) continue;
                    nodeToCluster.put(v, v);
                }
                Multimap clusterToMembers = (Multimap)nodeToCluster.entrySet().stream().collect(Multimaps.toMultimap(Map.Entry::getValue, Map.Entry::getKey, HashMultimap::create));
                Stream<Object> expandedLookups = GraphChange.expand(triplePattern, Triple.createMatch(null, null, null), x -> {
                    Set<Node> sources = clusterToMembers.get(x);
                    Set<Node> r = !sources.isEmpty() ? sources : (renamedNodes.containsKey(x) ? sources : Collections.singleton(x));
                    return r;
                });
                List tmpX = expandedLookups.collect(Collectors.toList());
                expandedLookups = tmpX.stream();
                Stream rawTriples = expandedLookups.flatMap(pattern -> Streams.stream((Iterator)delta.find(pattern)));
                Stream<Object> stream = rawTriples.flatMap(triple -> {
                    Triple replacement;
                    boolean isRemapped = tripleReplacements.containsKey(triple);
                    Stream<Object> r = isRemapped ? ((replacement = (Triple)tripleReplacements.get(triple)) == null ? Stream.empty() : Stream.of(replacement)) : Stream.of(triple);
                    return r;
                }).flatMap(triple -> GraphChange.expand(triple, triplePattern, x -> GraphChange.nullableSingleton((Node)renamedNodes.getOrDefault(x, x))));
                List tmp = stream.collect(Collectors.toList());
                stream = tmp.stream();
                ExtendedIterator result = WrappedIterator.create(stream.iterator());
                return result;
            }
        };
    }

    private static /* synthetic */ Triple lambda$toUpdateRequest$5(NodeTransform nodeTransform, Triple t) {
        return NodeTransformLib.transform((NodeTransform)nodeTransform, (Triple)t);
    }
}

