/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.schema;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.aksw.jena_sparql_api.entity.graph.metamodel.ResourceState;
import org.aksw.jena_sparql_api.schema.NodeSchema;
import org.aksw.jena_sparql_api.schema.PropertySchema;
import org.aksw.jena_sparql_api.schema.ResourceCache;
import org.aksw.jena_sparql_api.schema.ShapedProperty;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactoryQuery;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.path.Path;

public class ShapedNode {
    protected Node src;
    protected Resource res;
    protected ResourceCache resourceCache;
    protected Collection<NodeSchema> nodeSchemas;
    protected QueryExecutionFactoryQuery conn;

    public ShapedNode(Node src, Collection<NodeSchema> nodeSchemas, ResourceCache resourceCache, QueryExecutionFactoryQuery conn) {
        this.src = src;
        this.resourceCache = resourceCache;
        this.nodeSchemas = nodeSchemas;
        this.conn = conn;
    }

    public static ShapedNode create(Node src, NodeSchema nodeSchema, ResourceCache resourceCache, QueryExecutionFactoryQuery conn) {
        return ShapedNode.create(src, Collections.singleton(nodeSchema), resourceCache, conn);
    }

    public static ShapedNode create(Node src, Collection<NodeSchema> nodeSchemas, ResourceCache resourceCache, QueryExecutionFactoryQuery conn) {
        return new ShapedNode(src, nodeSchemas, resourceCache, conn);
    }

    public ResourceCache getResourceCache() {
        return this.resourceCache;
    }

    public ResourceState getResourceState() {
        return this.resourceCache.get(this.src);
    }

    public Node getSourceNode() {
        return this.src;
    }

    public QueryExecutionFactoryQuery getConnection() {
        return this.conn;
    }

    public Map<Path, ShapedProperty> getShapedProperties() {
        LinkedHashMap<Path, ShapedProperty> result = new LinkedHashMap<Path, ShapedProperty>();
        for (NodeSchema nss : this.nodeSchemas) {
            for (PropertySchema propertySchema : nss.getPredicateSchemas()) {
                Path path = propertySchema.getPath();
                ShapedProperty sp = result.computeIfAbsent(path, p -> new ShapedProperty(this, path));
                sp.addShape(propertySchema);
            }
        }
        return result;
    }

    public String toString() {
        return "ShapedNode [" + String.valueOf(this.src) + "]";
    }

    public ShapedProperty getShapedProperty(Path path) {
        Map<Path, ShapedProperty> map = this.getShapedProperties();
        ShapedProperty result = map.get(path);
        return result;
    }
}

