/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.schema;

import java.util.Iterator;
import java.util.List;
import org.aksw.commons.rx.lookup.LookupService;
import org.aksw.jena_sparql_api.entity.graph.metamodel.RMM;
import org.aksw.jena_sparql_api.entity.graph.metamodel.ResourceMetamodel;
import org.aksw.jena_sparql_api.lookup.LookupServiceSparqlQuery;
import org.aksw.jena_sparql_api.rdf.collections.ResourceUtils;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactoryQuery;
import org.aksw.jenax.reprogen.core.MapperProxyUtils;
import org.aksw.jenax.stmt.core.SparqlStmtMgr;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphUtil;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.modify.TemplateLib;
import org.apache.jena.sparql.syntax.Template;

public class ResourceExplorer {
    protected LookupService<Node, ResourceMetamodel> metamodelLookup;

    public static LookupService<Node, ResourceMetamodel> createMetamodelLookup(QueryExecutionFactoryQuery qef) {
        Query query = SparqlStmtMgr.loadQuery((String)"resource-criticalmodel-defaultgraph.rq");
        Var var = Var.alloc((String)"src");
        Template template = query.getConstructTemplate();
        Query selectQuery = query.cloneQuery();
        selectQuery.setQuerySelectType();
        LookupService result = new LookupServiceSparqlQuery(qef, selectQuery, var).mapValues((node, table) -> {
            Model m = ModelFactory.createDefaultModel();
            Iterator it = TemplateLib.calcTriples((List)template.getTriples(), (Iterator)table.rows());
            GraphUtil.add((Graph)m.getGraph(), (Iterator)it);
            Resource r = m.wrapAsResource(node);
            return r;
        }).mapValues((node, targetResource) -> {
            ResourceMetamodel r = (ResourceMetamodel)ResourceUtils.getReversePropertyValue((Resource)targetResource, (Property)RMM.targetResource, ResourceMetamodel.class);
            return r;
        }).mapValues((node, r) -> (ResourceMetamodel)MapperProxyUtils.skolemize((String)"http://www.example.org/", (Resource)r).as(ResourceMetamodel.class));
        return result;
    }
}

