/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.datashape.viewselector;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.aksw.jena_sparql_api.algebra.expr.transform.ExprTransformVirtualBnodeUris;
import org.aksw.jena_sparql_api.core.utils.QueryExecutionUtils;
import org.aksw.jena_sparql_api.rx.entity.engine.EntityQueryRx;
import org.aksw.jena_sparql_api.rx.entity.model.EntityBaseQuery;
import org.aksw.jena_sparql_api.rx.entity.model.EntityGraphFragment;
import org.aksw.jena_sparql_api.rx.entity.model.EntityQueryBasic;
import org.aksw.jena_sparql_api.rx.entity.model.EntityQueryImpl;
import org.aksw.jena_sparql_api.rx.entity.model.EntityTemplate;
import org.aksw.jena_sparql_api.rx.entity.model.EntityTemplateImpl;
import org.aksw.jena_sparql_api.rx.entity.model.GraphPartitionJoin;
import org.aksw.jenax.arq.util.node.NodeTransformLib2;
import org.aksw.jenax.arq.util.node.PathUtils;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.arq.util.var.VarGeneratorBlacklist;
import org.aksw.jenax.arq.util.var.Vars;
import org.aksw.jenax.model.shacl.domain.ShHasTargets;
import org.aksw.jenax.model.shacl.domain.ShNodeShape;
import org.aksw.jenax.model.shacl.util.ShSparqlTargets;
import org.aksw.jenax.sparql.fragment.api.Fragment;
import org.aksw.jenax.sparql.fragment.api.Fragment1;
import org.aksw.jenax.sparql.fragment.api.Fragment2;
import org.aksw.jenax.sparql.fragment.impl.Concept;
import org.aksw.jenax.sparql.fragment.impl.ConceptUtils;
import org.aksw.jenax.sparql.fragment.impl.FragmentImpl;
import org.aksw.jenax.sparql.fragment.impl.FragmentUtils;
import org.apache.jena.graph.FrontsNode;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.SortCondition;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdfconnection.RDFConnectionFactory;
import org.apache.jena.rdfconnection.SparqlQueryConnection;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_Str;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.aggregate.AggMin;
import org.apache.jena.sparql.expr.aggregate.Aggregator;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementBind;
import org.apache.jena.sparql.syntax.ElementData;
import org.apache.jena.sparql.syntax.Template;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.topbraid.shacl.model.SHFactory;
import org.topbraid.shacl.vocabulary.SH;

public class EntityClassifier {
    public static final Property classifier = ResourceFactory.createProperty((String)"http://jsa.aksw.org/classifier");
    protected Map<Node, Fragment> idToCondition = new LinkedHashMap<Node, Fragment>();
    protected List<Var> entityKeyVars;
    private static final Logger logger = LoggerFactory.getLogger(EntityClassifier.class);

    public EntityClassifier(Var var) {
        this(Collections.singletonList(var));
    }

    public EntityClassifier(List<Var> entityKeyVars) {
        this.entityKeyVars = entityKeyVars;
    }

    public EntityClassifier addCondition(Node conditionId, Fragment relation) {
        this.idToCondition.put(conditionId, relation);
        return this;
    }

    public Fragment createClassifyingRelation() {
        HashSet<Var> blacklist = new HashSet<Var>();
        blacklist.addAll(this.entityKeyVars);
        for (Fragment c : this.idToCondition.values()) {
            blacklist.addAll(c.getVarsMentioned());
        }
        Var conditionVar = VarGeneratorBlacklist.create((String)"conditionId", blacklist).next();
        VarGeneratorBlacklist bnodeVarGen = VarGeneratorBlacklist.create((String)"bn", blacklist);
        Map<Var, Var> bnodeRemap = blacklist.stream().filter(v -> v.getName().startsWith("?")).collect(Collectors.toMap(v -> v, v -> bnodeVarGen.next()));
        ArrayList<Element> unionMembers = new ArrayList<Element>(this.idToCondition.size());
        for (Map.Entry<Node, Fragment> e : this.idToCondition.entrySet()) {
            Node cId = e.getKey();
            Fragment c = e.getValue();
            c = c.applyNodeTransform(NodeTransformLib2.wrapWithNullAsIdentity(bnodeRemap::get));
            Fragment part = c.rename(this.entityKeyVars);
            List elts = part.getElements();
            elts.add(new ElementBind(conditionVar, (Expr)NodeValue.makeNode((Node)cId)));
            unionMembers.add(ElementUtils.groupIfNeeded((Iterable)elts));
        }
        Element union = ElementUtils.unionIfNeeded(unionMembers);
        ArrayList<Var> finalVars = new ArrayList<Var>(this.entityKeyVars);
        finalVars.add(conditionVar);
        FragmentImpl result = new FragmentImpl(union, finalVars);
        return result;
    }

    protected EntityGraphFragment createGraphFragmentGeneric(Fragment candidate) {
        throw new RuntimeException("not implemented");
    }

    public EntityGraphFragment createGraphFragment() {
        Fragment2 r = this.createClassifyingRelation().toFragment2();
        Var entityVar = r.getSourceVar();
        Var classVar = r.getTargetVar();
        EntityTemplateImpl et = new EntityTemplateImpl(Collections.singletonList(entityVar), new Template(BasicPattern.wrap(Arrays.asList(Triple.create((Node)entityVar, (Node)classifier.asNode(), (Node)classVar)))), new LinkedHashMap());
        EntityGraphFragment egf = new EntityGraphFragment(this.entityKeyVars, (EntityTemplate)et, r.getElement());
        return egf;
    }

    public Map<Node, Fragment> getIdToCondition() {
        return this.idToCondition;
    }

    public EntityQueryBasic toEntityQuery(Fragment candidates) {
        return null;
    }

    public static Fragment1 createConceptTargetSubjectsOf(Node node) {
        return new Concept((Element)ElementUtils.createElementTriple((Node)Vars.s, (Node)node, (Node)Vars.o), Vars.s);
    }

    public static Fragment1 createConceptTargetObjectsOf(Node node) {
        return new Concept((Element)ElementUtils.createElementTriple((Node)Vars.s, (Node)node, (Node)Vars.o), Vars.o);
    }

    public static Fragment1 createConceptTargetClass(Node node) {
        return new Concept((Element)ElementUtils.createElementPath((Node)Vars.s, (Path)PathUtils.typeSubclassOf, (Node)node), Vars.s);
    }

    public static void registerNodeShapes(EntityClassifier entityClassifier, Model shaclModel) {
        List nodeShapes = shaclModel.listResourcesWithProperty(SH.property).mapWith(r -> (ShNodeShape)r.as(ShNodeShape.class)).toList();
        for (ShNodeShape nodeShape : nodeShapes) {
            EntityClassifier.registerNodeShape(entityClassifier, nodeShape);
        }
    }

    public static void registerNodeShape(EntityClassifier entityClassifier, ShNodeShape nodeShape) {
        Node nodeShapeNode = ExprTransformVirtualBnodeUris.bnodeToIri((Node)nodeShape.asNode());
        ShHasTargets hasTargets = (ShHasTargets)nodeShape.as(ShHasTargets.class);
        for (Resource extraTarget : hasTargets.getTargets()) {
            Query query = ShSparqlTargets.tryParseSparqlQuery((Resource)extraTarget);
            if (query != null) {
                System.out.println(query);
                entityClassifier.addCondition(nodeShapeNode, FragmentUtils.fromQuery((Query)query));
                continue;
            }
            logger.warn("Unsupported shacl target type");
        }
        Set targetNodes = hasTargets.getTargetNodes();
        if (!targetNodes.isEmpty()) {
            Collection nodes = targetNodes.stream().map(FrontsNode::asNode).collect(Collectors.toSet());
            Concept r = Concept.create((Iterable)nodes);
            entityClassifier.addCondition(nodeShapeNode, (Fragment)r);
        }
        Set targetClasses = hasTargets.getTargetClasses();
        for (Object target : targetClasses) {
            Fragment1 r = EntityClassifier.createConceptTargetClass(target.asNode());
            entityClassifier.addCondition(nodeShapeNode, (Fragment)r);
        }
        Set targetSubjectsOf = hasTargets.getTargetSubjectsOf();
        for (RDFNode target : targetSubjectsOf) {
            Fragment1 r = EntityClassifier.createConceptTargetSubjectsOf(target.asNode());
            entityClassifier.addCondition(nodeShapeNode, (Fragment)r);
        }
        Set targetObjectsOf = hasTargets.getTargetObjectsOf();
        for (RDFNode target : targetObjectsOf) {
            Fragment1 r = EntityClassifier.createConceptTargetObjectsOf(target.asNode());
            entityClassifier.addCondition(nodeShapeNode, (Fragment)r);
        }
    }

    public static void main(String[] args) {
        EntityClassifier entityClassifier = new EntityClassifier(Arrays.asList(Vars.s));
        SHFactory.ensureInited();
        Model shaclModel = RDFDataMgr.loadModel((String)"/home/raven/Projects/Eclipse/rmltk-parent/r2rml-resource-shacl/src/main/resources/r2rml.core.shacl.ttl");
        List nodeShapes = shaclModel.listResourcesWithProperty(SH.property).mapWith(r -> (ShNodeShape)r.as(ShNodeShape.class)).toList();
        for (ShNodeShape nodeShape : nodeShapes) {
            EntityClassifier.registerNodeShape(entityClassifier, nodeShape);
        }
        EntityGraphFragment entityGraphFragment = entityClassifier.createGraphFragment();
        Graph graph = RDFDataMgr.loadGraph((String)"/home/raven/Projects/Eclipse/linkedgeodata-parent/legacy/linkedgeodata-docker/lgd-ontop-web/lgd.r2rml.ttl");
        Model model = ModelFactory.createModelForGraph((Graph)graph);
        RDFConnection conn = RDFConnectionFactory.connect((Dataset)DatasetFactory.wrap((Model)model));
        Query concept = QueryFactory.create((String)"SELECT DISTINCT ?s { ?s ?p ?o }");
        boolean materialize = false;
        if (materialize) {
            Query c = concept;
            Table table = QueryExecutionUtils.execSelectTable(() -> QueryExecutionFactory.create((Query)c, (Model)model));
            Query tmp = QueryFactory.create((String)"SELECT DISTINCT ?s {}");
            tmp.setQueryPattern((Element)new ElementData(table.getVars(), (List)Lists.newArrayList((Iterator)table.rows())));
            concept = tmp;
        }
        EntityBaseQuery ebq = new EntityBaseQuery(Collections.singletonList(Vars.s), (EntityTemplate)new EntityTemplateImpl(), concept);
        ExprAggregator partitionSortExpr = new ExprAggregator(Var.alloc((String)"dummy"), (Aggregator)new AggMin((Expr)new E_Str((Expr)new ExprVar(Vars.o))));
        ebq.getPartitionOrderBy().add(new SortCondition((Expr)partitionSortExpr, 1));
        EntityQueryImpl eq = new EntityQueryImpl();
        eq.setBaseQuery(ebq);
        eq.getMandatoryJoins().add(new GraphPartitionJoin(entityGraphFragment));
        EntityQueryBasic basic = EntityQueryRx.assembleEntityAndAttributeParts((EntityQueryImpl)eq);
        System.out.println("Entity Query: " + String.valueOf(basic));
        EntityQueryRx.execConstructEntitiesNg(arg_0 -> ((SparqlQueryConnection)conn).query(arg_0), (EntityQueryBasic)basic).forEach(quad -> System.out.println(quad));
        Fragment r2 = entityClassifier.createClassifyingRelation();
        Fragment1 testConcept = ConceptUtils.createForRdfType((String)"http://foo.bar/baz");
        Fragment s = testConcept.join().with(r2, new Var[]{(Var)r2.getVars().get(0)});
        Fragment grouped = FragmentUtils.groupBy((Fragment)s, (Var)((Var)s.getVars().iterator().next()), (Var)Vars.c, (boolean)false);
        System.out.println("Grouped relation: " + String.valueOf(grouped));
        Op op = Algebra.optimize((Op)Algebra.compile((Element)grouped.getElement()));
        System.out.println(op);
    }
}

