/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.entity.graph.metamodel;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import io.reactivex.rxjava3.core.Flowable;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.rx.lookup.LookupService;
import org.aksw.jena_sparql_api.collection.observable.ObservableGraphImpl;
import org.aksw.jena_sparql_api.core.FluentQueryExecutionFactory;
import org.aksw.jena_sparql_api.entity.graph.metamodel.ClassRelationModel;
import org.aksw.jena_sparql_api.entity.graph.metamodel.ConceptManagerImpl;
import org.aksw.jena_sparql_api.entity.graph.metamodel.DatasetMetamodel;
import org.aksw.jena_sparql_api.entity.graph.metamodel.GraphPredicateStats;
import org.aksw.jena_sparql_api.entity.graph.metamodel.PredicateStats;
import org.aksw.jena_sparql_api.entity.graph.metamodel.RGDMetamodel;
import org.aksw.jena_sparql_api.entity.graph.metamodel.ResourceGraphMetamodel;
import org.aksw.jena_sparql_api.entity.graph.metamodel.ResourceGraphPropertyMetamodel;
import org.aksw.jena_sparql_api.entity.graph.metamodel.ResourceMetamodel;
import org.aksw.jena_sparql_api.rdf.collections.ResourceUtils;
import org.aksw.jena_sparql_api.schema.NodeSchema;
import org.aksw.jena_sparql_api.schema.NodeSchemaDataFetcher;
import org.aksw.jena_sparql_api.schema.NodeSchemaFromNodeShape;
import org.aksw.jena_sparql_api.schema.PropertySchema;
import org.aksw.jena_sparql_api.schema.PropertySchemaFromPropertyShape;
import org.aksw.jena_sparql_api.schema.ResourceExplorer;
import org.aksw.jena_sparql_api.schema.SHAnnotatedClass;
import org.aksw.jenax.arq.util.triple.TripleUtils;
import org.aksw.jenax.dataaccess.sparql.connection.query.SparqlQueryConnectionJsa;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactory;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactoryOverSparqlQueryConnection;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactoryQuery;
import org.aksw.jenax.reprogen.core.JenaPluginUtils;
import org.aksw.jenax.reprogen.core.MapperProxyUtils;
import org.aksw.jenax.reprogen.hashid.HashIdCxt;
import org.aksw.jenax.sparql.fragment.api.Fragment1;
import org.aksw.jenax.sparql.fragment.impl.Concept;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdfconnection.RDFConnectionFactory;
import org.apache.jena.rdfconnection.SparqlQueryConnection;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.sys.JenaSystem;
import org.apache.jena.vocabulary.DCAT;
import org.topbraid.shacl.model.SHFactory;

public class MainPlaygroundResourceMetamodel {
    public static void init() {
        JenaSystem.init();
        SHFactory.ensureInited();
        JenaPluginUtils.registerResourceClasses((Class[])new Class[]{NodeSchemaFromNodeShape.class, PropertySchemaFromPropertyShape.class, SHAnnotatedClass.class, ResourceMetamodel.class, ResourceGraphMetamodel.class, ResourceGraphPropertyMetamodel.class, PredicateStats.class, GraphPredicateStats.class, RGDMetamodel.class, ClassRelationModel.class, DatasetMetamodel.class});
    }

    public static void main(String[] args) {
        MainPlaygroundResourceMetamodel.init();
        ConceptManagerImpl cm = new ConceptManagerImpl();
        Node name = cm.getOrCreate((Fragment1)Concept.parse((String)"?s { ?s a <Person> }"));
        Node name2 = cm.getOrCreate((Fragment1)Concept.parse((String)"?s { ?s a <Person> }"));
        System.out.println(name);
        System.out.println(name2);
        MainPlaygroundResourceMetamodel.createMetaModelQuery();
    }

    public static Flowable<ResourceMetamodel> computeCriticalMetamodel(SparqlQueryConnection conn, List<Node> nodes) {
        QueryExecutionFactoryOverSparqlQueryConnection qef = new QueryExecutionFactoryOverSparqlQueryConnection(conn);
        LookupService<Node, ResourceMetamodel> lookupService = ResourceExplorer.createMetamodelLookup((QueryExecutionFactoryQuery)qef);
        List tmp = lookupService.fetchList(nodes);
        System.out.println("Results:");
        for (ResourceMetamodel r : tmp) {
            System.out.println("Metamodel for: " + String.valueOf(r.getTargetResource()));
            Map<Node, ResourceGraphMetamodel> rgm = r.byGraph();
            for (Map.Entry<Node, ResourceGraphMetamodel> e : rgm.entrySet()) {
                System.out.println("  Graph: " + String.valueOf(e.getKey()));
                ResourceGraphMetamodel rg = e.getValue();
                for (int i = 0; i < 2; ++i) {
                    boolean isFwd = i == 0;
                    System.out.println("    isFwd: " + isFwd);
                    RGDMetamodel rgd = rg.getStats(isFwd);
                    if (rgd == null) continue;
                    Map<Node, PredicateStats> rgpm = rgd.getPredicateStats();
                    for (Map.Entry<Node, PredicateStats> f : rgpm.entrySet()) {
                        System.out.println("      " + String.valueOf(f.getKey()));
                        System.out.println("      " + f.getValue().getValueCount());
                    }
                }
            }
        }
        for (ResourceMetamodel x : tmp) {
            HashIdCxt hashIdCxt = MapperProxyUtils.getHashId((RDFNode)x);
            Map renames = hashIdCxt.getStringIdMapping();
            ResourceUtils.renameResources((String)"http://www.example.org/", (Map)renames);
        }
        Flowable result = Flowable.fromIterable((Iterable)tmp);
        return result;
    }

    public static void createMetaModelQuery() {
        SparqlQueryConnectionJsa conn = new SparqlQueryConnectionJsa((QueryExecutionFactory)((FluentQueryExecutionFactory)FluentQueryExecutionFactory.http((String)"https://dbpedia.org/sparql", (String[])new String[0]).config().withClientSideConstruct().end()).create());
        MainPlaygroundResourceMetamodel.computeCriticalMetamodel((SparqlQueryConnection)conn, Arrays.asList(NodeFactory.createURI((String)"http://dbpedia.org/resource/Leipzig")));
    }

    public static void testAnalyzeResources() {
        DatasetMetamodel dsm = (DatasetMetamodel)ModelFactory.createDefaultModel().createResource().as(DatasetMetamodel.class);
        Dataset ds = RDFDataMgr.loadDataset((String)"linkedgeodata-2018-04-04.dcat.ttl");
        RDFConnection conn = RDFConnectionFactory.connect((Dataset)ds);
        ObservableGraphImpl shapeGraph = ObservableGraphImpl.decorate(RDFDataMgr.loadGraph((String)"dcat-ap_2.0.0_shacl_shapes.ttl"));
        shapeGraph.addPropertyChangeListener(ev -> System.out.println("Event: " + String.valueOf(ev)));
        Model shapeModel = ModelFactory.createModelForGraph((Graph)shapeGraph);
        NodeSchemaFromNodeShape ns = (NodeSchemaFromNodeShape)shapeModel.createResource(DCAT.Dataset.getURI()).as(NodeSchemaFromNodeShape.class);
        ArrayListMultimap roots = ArrayListMultimap.create();
        Node sourceNode = NodeFactory.createURI((String)"http://dcat.linkedgeodata.org/dataset/osm-bremen-2018-04-04");
        NodeSchema userSchema = (NodeSchema)ModelFactory.createDefaultModel().createResource().as(NodeSchemaFromNodeShape.class);
        roots.put((Object)sourceNode, (Object)userSchema);
        roots.put((Object)sourceNode, (Object)ns);
        HashMultimap schemaToNodes = HashMultimap.create();
        Multimaps.invertFrom((Multimap)roots, (Multimap)schemaToNodes);
        MainPlaygroundResourceMetamodel.analyzeResources(dsm, (Multimap<NodeSchema, Node>)schemaToNodes, shapeModel, (QueryExecutionFactory)new QueryExecutionFactoryOverSparqlQueryConnection((SparqlQueryConnection)conn));
        RDFDataMgr.write((OutputStream)System.out, (Model)dsm.getModel(), (RDFFormat)RDFFormat.TURTLE_PRETTY);
    }

    public static void analyzeResources(DatasetMetamodel dsm, Multimap<NodeSchema, Node> schemaToNodes, Model shapeModel, QueryExecutionFactory qef) {
        NodeSchemaDataFetcher dataFetcher = new NodeSchemaDataFetcher();
        LookupService metaModelService = ResourceExplorer.createMetamodelLookup((QueryExecutionFactoryQuery)qef).cache();
    }

    public static void fillMetamodel(DatasetMetamodel dsm, Multimap<NodeSchema, Node> schemaToNodes, Graph dataGraph) {
        for (Map.Entry e : schemaToNodes.asMap().entrySet()) {
            NodeSchema nodeSchema = (NodeSchema)e.getKey();
            for (Node node : (Collection)e.getValue()) {
                MainPlaygroundResourceMetamodel.fillModel(dsm, dataGraph, nodeSchema, node);
            }
        }
    }

    public static void fillModel(DatasetMetamodel dsm, Graph dataGraph, NodeSchema nodeSchema, Node node) {
        ResourceGraphMetamodel rmm = dsm.getOrCreateResourceMetamodel(node);
        for (PropertySchema propertySchema : nodeSchema.getPredicateSchemas()) {
            boolean isForward = propertySchema.isForward();
            Set<? extends NodeSchema> targetSchemas = propertySchema.getTargetSchemas();
            if (targetSchemas == null) continue;
            for (NodeSchema nodeSchema2 : targetSchemas) {
                Iterator it = propertySchema.streamMatchingTriples(node, dataGraph).iterator();
                while (it.hasNext()) {
                    Triple triple = (Triple)it.next();
                    Node p = triple.getPredicate();
                    Node targetNode = TripleUtils.getTarget((Triple)triple, (boolean)isForward);
                    if (nodeSchema2 == null) continue;
                    MainPlaygroundResourceMetamodel.fillModel(dsm, dataGraph, nodeSchema2, targetNode);
                }
            }
        }
    }
}

