/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.entity.graph.metamodel;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.aksw.jenax.arq.util.node.NodeUtils;
import org.aksw.jenax.arq.util.triple.TripleUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.path.P_Path0;
import org.apache.jena.sparql.path.Path;

public class ResourceState {
    protected Node src;
    protected Map<Node, Map<Node, Triple>> fwdStore;
    protected Map<Node, Map<Node, Triple>> bwdStore;
    boolean isFwdComplete;
    boolean isBwdComplete;

    public ResourceState(Node src) {
        this(src, new HashMap<Node, Map<Node, Triple>>(), new HashMap<Node, Map<Node, Triple>>(), false, false);
    }

    public ResourceState(Node src, Map<Node, Map<Node, Triple>> fwdStore, Map<Node, Map<Node, Triple>> bwdStore, boolean isFwdComplete, boolean isBwdComplete) {
        this.src = src;
        this.fwdStore = fwdStore;
        this.bwdStore = bwdStore;
        this.isFwdComplete = isFwdComplete;
        this.isBwdComplete = isBwdComplete;
    }

    public void add(boolean isFwd, Node p, Node o) {
        Triple t = TripleUtils.create((Node)this.src, (Node)p, (Node)o, (boolean)isFwd);
        if (isFwd) {
            this.fwdStore.computeIfAbsent(p, pp -> new HashMap()).computeIfAbsent(o, oo -> t);
        } else {
            this.bwdStore.computeIfAbsent(p, pp -> new HashMap()).computeIfAbsent(o, oo -> t);
        }
    }

    public void declarePredicateSeen(boolean isFwd, Node p) {
        if (isFwd) {
            this.fwdStore.computeIfAbsent(p, pp -> new HashMap());
        } else {
            this.bwdStore.computeIfAbsent(p, pp -> new HashMap());
        }
    }

    public void delete(boolean isFwd, Node p, Node o) {
        if (isFwd) {
            Map<Node, Triple> om = this.fwdStore.get(p);
            om.remove(o);
        } else {
            Map<Node, Triple> om = this.bwdStore.get(p);
            om.remove(o);
        }
    }

    public Set<Node> getTargets(boolean isFwd, Node p) {
        Set result = isFwd ? (Set)Optional.ofNullable(this.fwdStore.get(p)).map(Map::keySet).orElse(null) : (Set)Optional.ofNullable(this.bwdStore.get(p)).map(Map::keySet).orElse(null);
        return result;
    }

    public Stream<Triple> streamCachedTriples() {
        return Stream.concat(this.fwdStore.entrySet().stream().flatMap(map -> ((Map)map.getValue()).values().stream()), this.bwdStore.entrySet().stream().flatMap(map -> ((Map)map.getValue()).values().stream()));
    }

    public Stream<TriplePath> find(Path path, Node o) {
        return null;
    }

    public Stream<Triple> find(boolean isFwd, Node p, Node o) {
        Triple t = TripleUtils.create((Node)this.src, (Node)p, (Node)o, (boolean)isFwd);
        Stream<Triple> result = isFwd ? (NodeUtils.isNullOrAny((Node)p) ? (this.isFwdComplete ? this.findO(o, this.fwdStore.values().stream()) : null) : this.findO(o, Stream.ofNullable(this.fwdStore.get(p)))) : (NodeUtils.isNullOrAny((Node)p) ? (this.isBwdComplete ? this.findO(o, this.bwdStore.values().stream()) : null) : this.findO(o, Stream.ofNullable(this.bwdStore.get(p))));
        return result;
    }

    protected Stream<Triple> findO(Node o, Stream<Map<Node, Triple>> stream) {
        return NodeUtils.isNullOrAny((Node)o) ? stream.flatMap(map -> map.values().stream()) : stream.flatMap(map -> Stream.ofNullable((Triple)map.get(o)));
    }

    public Set<Node> getSeenPredicates(boolean isFwd) {
        Set<Node> result = isFwd ? this.fwdStore.keySet() : this.bwdStore.keySet();
        return result;
    }

    public void setFwdComplete(boolean yesOrNo) {
        this.isFwdComplete = yesOrNo;
    }

    public void setBwdComplete(boolean yesOrNo) {
        this.isBwdComplete = yesOrNo;
    }

    public Set<Node> getFromCache(Path path) {
        if (!(path instanceof P_Path0)) {
            return null;
        }
        P_Path0 p0 = (P_Path0)path;
        boolean isFwd = p0.isForward();
        Node p = p0.getNode();
        Set<Node> result = this.getTargets(isFwd, p);
        return result;
    }
}

