/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.collection.observable;

import org.aksw.jenax.arq.util.triple.TripleConstraint;
import org.aksw.jenax.arq.util.triple.TripleUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.GraphBase;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NiceIterator;

public class GraphWithFilter
extends GraphBase {
    protected Graph delegate;
    protected TripleConstraint predicate;

    public GraphWithFilter(Graph graph, TripleConstraint predicate) {
        this.delegate = graph;
        this.predicate = predicate;
    }

    public Graph get() {
        return this.delegate;
    }

    public void performAdd(Triple t) {
        boolean isAccepted = this.predicate.test((Object)t);
        if (isAccepted) {
            this.get().add(t);
        }
    }

    public void performDelete(Triple t) {
        boolean isAccepted = this.predicate.test((Object)t);
        if (isAccepted) {
            this.get().delete(t);
        }
    }

    public Triple createCombinedPattern(Node s, Node p, Node o) {
        Triple a = this.predicate.getMatchTriple();
        Triple b = Triple.createMatch((Node)s, (Node)p, (Node)o);
        Triple result = TripleUtils.logicalAnd((Triple)a, (Triple)b);
        return result;
    }

    public void remove(Node s, Node p, Node o) {
        Triple combinedPattern = this.createCombinedPattern(s, p, o);
        this.get().remove(combinedPattern.getMatchSubject(), combinedPattern.getMatchPredicate(), combinedPattern.getMatchObject());
    }

    protected ExtendedIterator<Triple> graphBaseFind(Triple t) {
        Triple combinedPattern = this.createCombinedPattern(t.getMatchSubject(), t.getMatchPredicate(), t.getMatchObject());
        ExtendedIterator result = combinedPattern == null ? NiceIterator.emptyIterator() : this.get().find(combinedPattern).filterKeep(arg_0 -> this.predicate.test(arg_0));
        return result;
    }
}

