/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.shape.syntax;

import java.util.List;
import org.aksw.jena_sparql_api.shape.algebra.op.Op;
import org.aksw.jena_sparql_api.shape.algebra.op.OpAnd;
import org.aksw.jena_sparql_api.shape.algebra.op.OpConcept;
import org.aksw.jena_sparql_api.shape.algebra.op.OpEnumeration;
import org.aksw.jena_sparql_api.shape.algebra.op.OpExists;
import org.aksw.jena_sparql_api.shape.algebra.op.OpFilter;
import org.aksw.jena_sparql_api.shape.algebra.op.OpFocus;
import org.aksw.jena_sparql_api.shape.algebra.op.OpForAll;
import org.aksw.jena_sparql_api.shape.algebra.op.OpTop;
import org.aksw.jena_sparql_api.shape.algebra.op.OpType;
import org.aksw.jena_sparql_api.shape.syntax.Element;
import org.aksw.jena_sparql_api.shape.syntax.ElementAlias;
import org.aksw.jena_sparql_api.shape.syntax.ElementBind;
import org.aksw.jena_sparql_api.shape.syntax.ElementDifference;
import org.aksw.jena_sparql_api.shape.syntax.ElementEnumeration;
import org.aksw.jena_sparql_api.shape.syntax.ElementExists;
import org.aksw.jena_sparql_api.shape.syntax.ElementFilter;
import org.aksw.jena_sparql_api.shape.syntax.ElementFocus;
import org.aksw.jena_sparql_api.shape.syntax.ElementForAll;
import org.aksw.jena_sparql_api.shape.syntax.ElementGroup;
import org.aksw.jena_sparql_api.shape.syntax.ElementService;
import org.aksw.jena_sparql_api.shape.syntax.ElementSparqlConcept;
import org.aksw.jena_sparql_api.shape.syntax.ElementType;
import org.aksw.jena_sparql_api.shape.syntax.ElementUnion;
import org.aksw.jena_sparql_api.shape.syntax.ElementValue;
import org.aksw.jena_sparql_api.shape.syntax.ElementVisitor;
import org.aksw.jenax.sparql.fragment.api.Fragment2;
import org.aksw.jenax.sparql.fragment.impl.Fragment2Impl;
import org.apache.jena.sparql.path.Path;

public class ElementVisitorSparql
implements ElementVisitor<Op> {
    @Override
    public OpType visit(ElementType el) {
        OpType result = new OpType(el.getType());
        return result;
    }

    @Override
    public OpConcept visit(ElementSparqlConcept el) {
        OpConcept result = new OpConcept(el.getConcept());
        return result;
    }

    @Override
    public Op visit(ElementDifference el) {
        return null;
    }

    @Override
    public Op visit(ElementUnion el) {
        return null;
    }

    @Override
    public Op visit(ElementValue el) {
        return null;
    }

    @Override
    public Op visit(ElementEnumeration el) {
        OpEnumeration result = new OpEnumeration(el.getValues());
        return result;
    }

    @Override
    public Op visit(ElementFocus el) {
        return null;
    }

    @Override
    public Op visit(ElementGroup el) {
        List<Element> members = el.getMembers();
        Op result = new OpTop();
        for (Element e : members) {
            if (e instanceof ElementFilter) {
                result = new OpFilter(result, ((ElementFilter)e).getExpr());
                continue;
            }
            if (e instanceof ElementFocus) {
                result = new OpFocus(result, ((ElementFocus)e).getPath());
                continue;
            }
            Op x = e.accept(this);
            result = new OpAnd(result, x);
        }
        return result;
    }

    @Override
    public Op visit(ElementAlias el) {
        return null;
    }

    @Override
    public Op visit(ElementBind el) {
        return null;
    }

    @Override
    public Op visit(ElementService el) {
        return null;
    }

    @Override
    public Op visit(ElementFilter el) {
        OpFilter result = new OpFilter(new OpTop(), el.getExpr());
        return result;
    }

    @Override
    public OpExists visit(ElementExists el) {
        Fragment2 relation = Fragment2Impl.create((Path)el.getPath());
        Op op = el.getFiller().accept(this);
        OpExists result = new OpExists(relation, op);
        return result;
    }

    @Override
    public Op visit(ElementForAll el) {
        Fragment2 relation = Fragment2Impl.create((Path)el.getPath());
        Op op = el.getFiller().accept(this);
        OpForAll result = new OpForAll(relation, op);
        return result;
    }
}

