/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.schema;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Range;
import com.google.common.collect.Table;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aksw.commons.rx.lookup.LookupService;
import org.aksw.jena_sparql_api.entity.graph.metamodel.MainPlaygroundResourceMetamodel;
import org.aksw.jena_sparql_api.entity.graph.metamodel.PredicateStats;
import org.aksw.jena_sparql_api.entity.graph.metamodel.ResourceMetamodel;
import org.aksw.jena_sparql_api.entity.graph.metamodel.ResourceState;
import org.aksw.jena_sparql_api.schema.NodeSchema;
import org.aksw.jena_sparql_api.schema.NodeSchemaFromNodeShape;
import org.aksw.jena_sparql_api.schema.PropertySchema;
import org.aksw.jena_sparql_api.schema.ResourceCache;
import org.aksw.jena_sparql_api.schema.ResourceExplorer;
import org.aksw.jena_sparql_api.schema.ShapedNode;
import org.aksw.jena_sparql_api.schema.ShapedProperty;
import org.aksw.jenax.arq.util.expr.ExprUtils;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.arq.util.syntax.QueryUtils;
import org.aksw.jenax.arq.util.triple.TripleFilter;
import org.aksw.jenax.arq.util.var.Vars;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactoryDataset;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactoryQuery;
import org.aksw.jenax.sparql.query.rx.SparqlRx;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.PathFactory;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.Template;
import org.apache.jena.vocabulary.DCAT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeSchemaDataFetcher {
    private static final Logger logger = LoggerFactory.getLogger(NodeSchemaDataFetcher.class);

    public static Query toQuery(Multimap<NodeSchema, Node> schemaAndNodes) {
        LinkedHashSet<Query> unionMembers = new LinkedHashSet<Query>();
        for (Map.Entry e : schemaAndNodes.asMap().entrySet()) {
            NodeSchema schema = (NodeSchema)e.getKey();
            Collection nodes = (Collection)e.getValue();
            Query unionMember = NodeSchemaDataFetcher.immediateSchemaToSparql(schema);
            QueryUtils.injectFilter((Query)unionMember, (Expr)ExprUtils.oneOf((Node)Vars.s, (Iterable)nodes));
            unionMembers.add(unionMember);
        }
        Query result = QueryUtils.unionConstruct(unionMembers);
        return result;
    }

    public void sync(Multimap<NodeSchema, Node> schemaAndNodes, QueryExecutionFactoryQuery conn, LookupService<Node, ResourceMetamodel> metaDataService, ResourceCache graphToResourceState) {
        HashMultimap done = HashMultimap.create();
        Multimap<NodeSchema, Node> next = schemaAndNodes;
        while (!next.isEmpty()) {
            Multimap<NodeSchema, Node> tmp = this.step(next, conn, (Multimap<NodeSchema, Node>)done, metaDataService, graphToResourceState);
            next = tmp;
        }
    }

    public Multimap<NodeSchema, Node> step(Multimap<NodeSchema, Node> schemaAndNodes, QueryExecutionFactoryQuery conn, Multimap<NodeSchema, Node> done, LookupService<Node, ResourceMetamodel> metaDataService, ResourceCache resourceCache) {
        HashMultimap next = HashMultimap.create();
        List allNodes = schemaAndNodes.values().stream().distinct().collect(Collectors.toList());
        Map metaData = metaDataService.fetchMap(allNodes);
        System.out.println("Showing " + metaData.size() + " metadata items:");
        metaData.entrySet().forEach(System.out::println);
        HashBasedTable dirToSrcToP = HashBasedTable.create();
        for (Map.Entry e : schemaAndNodes.asMap().entrySet()) {
            NodeSchema ns = (NodeSchema)e.getKey();
            for (PropertySchema propertySchema : ns.getPredicateSchemas()) {
                boolean isFwd = propertySchema.isForward();
                Node p = propertySchema.getPredicate();
                for (Node src : (Collection)e.getValue()) {
                    LinkedHashSet<Node> preds = (LinkedHashSet<Node>)dirToSrcToP.get((Object)isFwd, (Object)src);
                    if (preds == null) {
                        preds = new LinkedHashSet<Node>();
                        dirToSrcToP.put((Object)isFwd, (Object)src, preds);
                    }
                    preds.add(p);
                }
            }
        }
        long valueCountThreshold = 10L;
        Var ip = Var.alloc((String)"ip");
        Var io = Var.alloc((String)"io");
        Triple triple = Triple.create((Node)Vars.s, (Node)Vars.p, (Node)Vars.o);
        Triple bwdTriplePattern = Triple.create((Node)io, (Node)ip, (Node)Vars.s);
        ArrayList<Triple> tps = new ArrayList<Triple>(2);
        ArrayList<ElementGroup> tgtElts = new ArrayList<ElementGroup>();
        for (int i = 0; i < 2; ++i) {
            boolean isFwd = i == 0;
            Map map = dirToSrcToP.row((Object)isFwd);
            for (Map.Entry e : map.entrySet()) {
                Node node = (Node)e.getKey();
                Set preds = (Set)e.getValue();
                Iterator rs = resourceCache.getOrCreate(node);
                Set<Node> set = ((ResourceState)((Object)rs)).getSeenPredicates(isFwd);
                preds.removeAll(set);
                Node g = Quad.defaultGraphIRI;
                ResourceMetamodel resourceMetamodel = (ResourceMetamodel)metaData.get(node);
                Stream<PredicateStats> statsStream = resourceMetamodel == null ? null : resourceMetamodel.find(g, isFwd, Node.ANY);
                if (statsStream == null) continue;
                List stats = statsStream.collect(Collectors.toList());
                for (PredicateStats stat : stats) {
                    Node p = stat.getPredicateNode();
                    Long valueCount = stat.getValueCount();
                    if (valueCount == null || valueCount < valueCountThreshold) continue;
                    preds.remove(p);
                }
            }
            Multimap predsToSrcs = Multimaps.invertFrom((Multimap)Multimaps.forMap((Map)map), (Multimap)HashMultimap.create());
            if (predsToSrcs.isEmpty()) continue;
            Triple t = isFwd ? triple : bwdTriplePattern;
            tps.add(t);
            Var var = (Var)t.getSubject();
            ElementTriplesBlock tp = ElementUtils.createElementTriple((Triple[])new Triple[]{t});
            for (Map.Entry entry : predsToSrcs.asMap().entrySet()) {
                Collection preds = (Collection)entry.getKey();
                Collection collection = (Collection)entry.getValue();
                ElementGroup elt = ElementUtils.createElementGroup((Element[])new Element[]{tp, new ElementFilter((Expr)ExprUtils.oneOf((Node)var, (Iterable)collection)), new ElementFilter((Expr)ExprUtils.oneOf((Node)Vars.p, (Iterable)preds))});
                tgtElts.add(elt);
            }
        }
        Query unionQuery = new Query();
        unionQuery.setQuerySelectType();
        unionQuery.setConstructTemplate(new Template(BasicPattern.wrap(tps)));
        unionQuery.setQueryPattern(ElementUtils.unionIfNeeded(tgtElts));
        logger.debug("Union Query: " + String.valueOf(unionQuery));
        System.out.println(unionQuery);
        SparqlRx.execSelectRaw((QueryExecutionFactoryQuery)conn, (Query)unionQuery).forEach(b -> {
            Node src = b.get(Vars.s);
            Node np = b.get(Vars.p);
            Node no = b.get(Vars.o);
            Node nip = b.get(ip);
            Node nio = b.get(io);
            boolean isFwd = np != null;
            Node p = isFwd ? np : nip;
            Node o = isFwd ? no : nio;
            ResourceState rs = resourceCache.get(src);
            rs.add(isFwd, p, o);
        });
        for (Table.Cell cell : dirToSrcToP.cellSet()) {
            boolean isFwd = (Boolean)cell.getRowKey();
            Node src = (Node)cell.getColumnKey();
            Set set = (Set)cell.getValue();
            ResourceState rs = resourceCache.get(src);
            for (Node node : set) {
                System.out.println("Declaring seen: " + String.valueOf(node));
                rs.declarePredicateSeen(isFwd, node);
            }
        }
        for (Map.Entry entry : schemaAndNodes.asMap().entrySet()) {
            NodeSchema ns = (NodeSchema)entry.getKey();
            for (PropertySchema propertySchema : ns.getPredicateSchemas()) {
                boolean isFwd = propertySchema.isForward();
                Node p = propertySchema.getPredicate();
                Set<? extends NodeSchema> set = propertySchema.getTargetSchemas();
                if (set == null) continue;
                for (NodeSchema nodeSchema : set) {
                    for (Node src : (Collection)entry.getValue()) {
                        ResourceState rs = resourceCache.get(src);
                        Set<Node> targets = rs.getTargets(isFwd, p);
                        if (targets == null) continue;
                        for (Node targetNode : targets) {
                            if (done.containsEntry((Object)nodeSchema, (Object)targetNode)) continue;
                            done.put((Object)nodeSchema, (Object)targetNode);
                            next.put((Object)nodeSchema, (Object)targetNode);
                        }
                    }
                }
            }
        }
        return next;
    }

    public static Query immediateSchemaToSparql(NodeSchema schema) {
        LinkedHashSet<E_Equals> fwdDisjunction = new LinkedHashSet<E_Equals>();
        LinkedHashSet<E_Equals> bwdDisjunction = new LinkedHashSet<E_Equals>();
        for (PropertySchema propertySchema : schema.getPredicateSchemas()) {
            boolean isFwd = propertySchema.isForward();
            Node p = propertySchema.getPredicate();
            E_Equals expr = new E_Equals((Expr)new ExprVar(Vars.p), (Expr)NodeValue.makeNode((Node)p));
            if (isFwd) {
                fwdDisjunction.add(expr);
                continue;
            }
            bwdDisjunction.add(expr);
        }
        for (TripleFilter tripleFilter : schema.getGenericPatterns()) {
        }
        Var ip = Var.alloc((String)"ip");
        Var var = Var.alloc((String)"io");
        Triple fwdTriplePattern = Triple.create((Node)Vars.s, (Node)Vars.p, (Node)Vars.o);
        Triple bwdTriplePattern = Triple.create((Node)var, (Node)ip, (Node)Vars.s);
        ArrayList<Triple> tps = new ArrayList<Triple>(2);
        ArrayList<Element> elts = new ArrayList<Element>(2);
        if (!fwdDisjunction.isEmpty()) {
            tps.add(fwdTriplePattern);
            elts.add(ElementUtils.groupIfNeeded((Element[])new Element[]{ElementUtils.createElement((Triple)fwdTriplePattern), new ElementFilter(ExprUtils.orifyBalanced(fwdDisjunction))}));
        }
        if (!bwdDisjunction.isEmpty()) {
            tps.add(bwdTriplePattern);
            elts.add(ElementUtils.groupIfNeeded((Element[])new Element[]{ElementUtils.createElement((Triple)bwdTriplePattern), new ElementFilter(ExprUtils.orifyBalanced(bwdDisjunction))}));
        }
        Query stdQuery = new Query();
        stdQuery.setQueryConstructType();
        stdQuery.setConstructTemplate(new Template(BasicPattern.wrap(tps)));
        stdQuery.setQueryPattern(ElementUtils.unionIfNeeded(elts));
        return stdQuery;
    }

    public static void main(String[] args) {
        MainPlaygroundResourceMetamodel.init();
        Model shaclModel = RDFDataMgr.loadModel((String)"dcat-ap_2.0.0_shacl_shapes.ttl");
        NodeSchema schema = (NodeSchema)shaclModel.createResource("http://data.europa.eu/r5r#Dataset_Shape").as(NodeSchemaFromNodeShape.class);
        Node datasetNode = NodeFactory.createURI((String)"http://dcat.linkedgeodata.org/dataset/osm-bremen-2018-04-04");
        HashMultimap roots = HashMultimap.create();
        roots.put((Object)schema, (Object)datasetNode);
        Dataset ds = RDFDataMgr.loadDataset((String)"linkedgeodata-2018-04-04.dcat.ttl");
        QueryExecutionFactoryDataset qef = new QueryExecutionFactoryDataset(ds);
        LookupService<Node, ResourceMetamodel> metaDataService = ResourceExplorer.createMetamodelLookup((QueryExecutionFactoryQuery)qef);
        NodeSchemaDataFetcher dataFetcher = new NodeSchemaDataFetcher();
        ResourceCache resourceCache = new ResourceCache();
        dataFetcher.sync((Multimap<NodeSchema, Node>)roots, (QueryExecutionFactoryQuery)qef, metaDataService, resourceCache);
        Graph graph = GraphFactory.createDefaultGraph();
        resourceCache.getMap().values().stream().flatMap(ResourceState::streamCachedTriples).forEach(arg_0 -> ((Graph)graph).add(arg_0));
        Model m = ModelFactory.createModelForGraph((Graph)graph);
        RDFDataMgr.write((OutputStream)System.out, (Model)m, (RDFFormat)RDFFormat.TURTLE_PRETTY);
        ShapedNode sn = ShapedNode.create(datasetNode, schema, resourceCache, (QueryExecutionFactoryQuery)qef);
        ShapedProperty sp = sn.getShapedProperties().get(PathFactory.pathLink((Node)DCAT.distribution.asNode()));
        System.out.println("Is in memory: " + sp.isInMemory());
        NodeSchemaDataFetcher.printShapedNode(sn);
    }

    public static void printShapedNode(ShapedNode sn) {
        System.out.println("Visisted: " + String.valueOf(sn.getSourceNode()));
        Map<Path, ShapedProperty> spm = sn.getShapedProperties();
        for (ShapedProperty sp : spm.values()) {
            Long cnt = (Long)sp.getValues().fetchCount().blockingGet();
            if (cnt == null) continue;
            System.out.println("Path: " + String.valueOf(sp.getPath()));
            System.out.println("Is in memory: " + sp.isInMemory());
            System.out.println("Is empty: " + sp.isEmpty());
            System.out.println(cnt);
            Map map = sp.getValues().fetchData(null, Range.closedOpen((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(3L)));
            for (ShapedNode tgt : map.values()) {
                NodeSchemaDataFetcher.printShapedNode(tgt);
            }
        }
    }
}

