/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.collection.observable;

import com.google.common.collect.Sets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.aksw.commons.collection.observable.CollectionChangedEvent;
import org.aksw.commons.collection.observable.CollectionChangedEventImpl;
import org.aksw.commons.collection.observable.Registration;
import org.aksw.commons.collection.observable.StreamOps;
import org.aksw.jena_sparql_api.collection.observable.GraphWithFilter;
import org.aksw.jena_sparql_api.collection.observable.ObservableGraph;
import org.aksw.jenax.arq.util.triple.TripleConstraint;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;

public class ObservableSubGraph
extends GraphWithFilter
implements ObservableGraph {
    public ObservableSubGraph(ObservableGraph graph, TripleConstraint predicate) {
        super(graph, predicate);
    }

    public static ObservableSubGraph decorate(ObservableGraph graph, TripleConstraint predicate) {
        return new ObservableSubGraph(graph, predicate);
    }

    @Override
    public ObservableGraph get() {
        return (ObservableGraph)super.get();
    }

    @Override
    public boolean delta(Collection<? extends Triple> rawAdditions, Collection<?> rawDeletions) {
        Collection filteredRemovals = StreamOps.filter(rawDeletions.stream(), (Predicate)this.predicate).collect(Collectors.toSet());
        Collection filteredAdditions = rawAdditions.stream().filter((Predicate<? extends Triple>)this.predicate).collect(Collectors.toSet());
        return this.get().delta(filteredAdditions, filteredRemovals);
    }

    public static <T> Set<T> filterSet(Set<T> set, Predicate<? super T> predicate) {
        return set == null ? null : Sets.filter(set, predicate::test);
    }

    public static CollectionChangedEvent<Triple> filter(Object self, CollectionChangedEvent<Triple> ev, TripleConstraint tripleConstraint) {
        return new CollectionChangedEventImpl(self, (Object)new GraphWithFilter((Graph)ev.getOldValue(), tripleConstraint), (Object)new GraphWithFilter((Graph)ev.getNewValue(), tripleConstraint), ObservableSubGraph.filterSet((Set)ev.getAdditions(), tripleConstraint), ObservableSubGraph.filterSet((Set)ev.getDeletions(), tripleConstraint), ObservableSubGraph.filterSet((Set)ev.getRefreshes(), tripleConstraint));
    }

    @Override
    public Runnable addVetoableChangeListener(VetoableChangeListener listener) {
        return this.get().addVetoableChangeListener(ev -> {
            CollectionChangedEvent<Triple> newEv = ObservableSubGraph.filter(this, (CollectionChangedEvent<Triple>)((CollectionChangedEvent)ev), this.predicate);
            if (newEv.hasChanges()) {
                listener.vetoableChange((PropertyChangeEvent)newEv);
            }
        });
    }

    @Override
    public Registration addPropertyChangeListener(PropertyChangeListener listener) {
        return this.get().addPropertyChangeListener(ev -> {
            CollectionChangedEvent<Triple> newEv = ObservableSubGraph.filter(this, (CollectionChangedEvent<Triple>)((CollectionChangedEvent)ev), this.predicate);
            if (newEv.hasChanges()) {
                listener.propertyChange((PropertyChangeEvent)newEv);
            }
        });
    }
}

