/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.schema;

import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Stream;
import org.aksw.jena_sparql_api.schema.NodeSchemaFromNodeShape;
import org.aksw.jena_sparql_api.schema.PropertySchema;
import org.aksw.jena_sparql_api.schema.SHAnnotatedClass;
import org.aksw.jenax.annotation.reprogen.Iri;
import org.aksw.jenax.annotation.reprogen.IriType;
import org.aksw.jenax.annotation.reprogen.ResourceView;
import org.aksw.jenax.arq.util.triple.TripleUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.P_ReverseLink;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.topbraid.shacl.model.SHPropertyShape;
import org.topbraid.shacl.vocabulary.SH;

@ResourceView
public interface PropertySchemaFromPropertyShape
extends PropertySchema,
Resource {
    default public SHPropertyShape getPropertyShape() {
        return (SHPropertyShape)this.as(SHPropertyShape.class);
    }

    @Iri(value="http://www.w3.org/ns/shacl#class")
    public SHAnnotatedClass getSHClass();

    public PropertySchemaFromPropertyShape setSHClass(Resource var1);

    @Iri(value="http://www.w3.org/ns/shacl#datatype")
    @IriType
    public String getDataTypeIri();

    public PropertySchemaFromPropertyShape setDataTypeIri(String var1);

    @Iri(value="http://www.w3.org/ns/shacl#minCount")
    @IriType
    public Long getMinCount();

    public PropertySchemaFromPropertyShape setMinCount(Long var1);

    @Iri(value="http://www.w3.org/ns/shacl#maxCount")
    @IriType
    public Long getMaxCount();

    public PropertySchemaFromPropertyShape setMaxCount(Long var1);

    @Override
    default public Node getPredicate() {
        SHPropertyShape propertyShape = this.getPropertyShape();
        Resource r = propertyShape.getPath();
        Resource p = r.hasProperty(SH.inversePath) ? r.getPropertyResourceValue(SH.inversePath) : r;
        Node result = p.asNode();
        return result;
    }

    @Override
    default public boolean isForward() {
        SHPropertyShape propertyShape = this.getPropertyShape();
        Resource r = propertyShape.getPath();
        boolean result = !r.hasProperty(SH.inversePath);
        return result;
    }

    @Override
    default public Path getPath() {
        boolean isFwd = this.isForward();
        Node p = this.getPredicate();
        Object result = isFwd ? new P_Link(p) : new P_ReverseLink(p);
        return result;
    }

    default public Set<NodeSchemaFromNodeShape> getTargetSchemas() {
        SHAnnotatedClass targetRes = this.getSHClass();
        Set<NodeSchemaFromNodeShape> result = null;
        if (targetRes != null) {
            result = targetRes.getNodeShapes();
        }
        return result;
    }

    @Override
    default public boolean canMatchTriples() {
        return true;
    }

    default public Triple createMatchTriple(Node source) {
        boolean isForward = this.isForward();
        Node predicate = this.getPredicate();
        Triple result = TripleUtils.createMatch((Node)source, (Node)predicate, (boolean)isForward);
        return result;
    }

    @Override
    default public boolean matchesTriple(Node source, Triple triple) {
        Triple matcher = this.createMatchTriple(source);
        boolean result = matcher.matches(triple);
        return result;
    }

    @Override
    default public long copyMatchingValues(Node source, Collection<Node> target, Graph sourceGraph) {
        boolean isForward = this.isForward();
        long result = this.streamMatchingTriples(source, sourceGraph).map(t -> TripleUtils.getTarget((Triple)t, (boolean)isForward)).peek(target::add).count();
        return result;
    }

    @Override
    default public Stream<Triple> streamMatchingTriples(Node source, Graph sourceGraph) {
        Triple matcher = this.createMatchTriple(source);
        ExtendedIterator it = sourceGraph.find(matcher);
        Stream result = Streams.stream((Iterator)it);
        return result;
    }

    @Override
    default public long copyMatchingTriples(Node source, Graph targetGraph, Graph sourceGraph) {
        long result = this.streamMatchingTriples(source, sourceGraph).peek(arg_0 -> ((Graph)targetGraph).add(arg_0)).count();
        return result;
    }
}

