/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.dboe;

import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.aksw.jena_sparql_api.dboe.QuadTableCore;
import org.aksw.jena_sparql_api.dboe.QuadTableCoreDiff;
import org.aksw.jena_sparql_api.dboe.QuadTableCoreFromNestedMapsImpl;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.core.mem.QuadTable;

public class QuadTableFromNestedMaps
implements QuadTable,
Transactional {
    protected AtomicReference<QuadTableCore> master = new AtomicReference<QuadTableCore>(this.newQuadStore());
    protected ThreadLocal<TxnState> local = ThreadLocal.withInitial(() -> null);

    protected AtomicReference<QuadTableCore> master() {
        return this.master;
    }

    protected ThreadLocal<TxnState> local() {
        return this.local;
    }

    protected QuadTableCore newQuadStore() {
        return new QuadTableCoreFromNestedMapsImpl();
    }

    public void clear() {
        TxnState txnState = this.local().get();
        txnState.diff.master.find(Node.ANY, Node.ANY, Node.ANY, Node.ANY).forEach(txnState.diff.deletions::add);
    }

    public void add(Quad quad) {
        this.local().get().diff.add(quad);
    }

    public void delete(Quad quad) {
        this.local().get().diff.delete(quad);
    }

    public void begin(ReadWrite readWrite) {
        TxnState txnState = this.local().get();
        if (txnState == null) {
            txnState = new TxnState();
            txnState.mode = readWrite;
            txnState.diff = new QuadTableCoreDiff(this.master.get(), this.newQuadStore(), this.newQuadStore());
            this.local().set(txnState);
        } else {
            ReadWrite current = txnState.mode;
            if (current != readWrite) {
                throw new IllegalStateException("Requested begin of txn with " + String.valueOf(readWrite) + " however a prior begin with " + String.valueOf(current) + " was not ended");
            }
        }
    }

    public void commit() {
        TxnState txnState = this.local().get();
        if (txnState != null) {
            txnState.diff.applyDiff();
        }
        this.end();
    }

    public void end() {
        this.local().remove();
    }

    public Stream<Quad> find(Node g, Node s, Node p, Node o) {
        Stream<Quad> result = this.local().get().diff.find(g, s, p, o);
        return result;
    }

    public Stream<Node> listGraphNodes() {
        return this.local().get().diff.listGraphNodes().filter(node -> !Quad.isDefaultGraph((Node)node));
    }

    public void begin(TxnType type) {
        throw new UnsupportedOperationException();
    }

    public boolean promote(Transactional.Promote mode) {
        throw new UnsupportedOperationException();
    }

    public ReadWrite transactionMode() {
        throw new UnsupportedOperationException();
    }

    public TxnType transactionType() {
        throw new UnsupportedOperationException();
    }

    public boolean isInTransaction() {
        TxnState txnState = this.local().get();
        boolean result = txnState != null;
        return result;
    }

    public void abort() {
        throw new UnsupportedOperationException();
    }

    public static class TxnState {
        ReadWrite mode;
        QuadTableCoreDiff diff;
    }
}

