/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.dataset.orderaware;

import java.util.function.Supplier;
import org.aksw.jena_sparql_api.dboe.QuadTableCore;
import org.aksw.jena_sparql_api.dboe.QuadTableCoreFromMapOfTripleTable;
import org.aksw.jena_sparql_api.dboe.QuadTableWithInsertOrderPreservation;
import org.aksw.jena_sparql_api.dboe.StorageRDFBasic;
import org.aksw.jena_sparql_api.dboe.TripleTableCore;
import org.aksw.jena_sparql_api.dboe.TripleTableCoreFromNestedMapsImpl;
import org.aksw.jena_sparql_api.dboe.TripleTableWithInsertOrderPreservation;
import org.apache.jena.dboe.storage.StoragePrefixes;
import org.apache.jena.dboe.storage.StorageRDF;
import org.apache.jena.dboe.storage.simple.StoragePrefixesSimpleMem;
import org.apache.jena.dboe.storage.system.DatasetGraphStorage;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.core.TransactionalLock;
import org.apache.jena.sys.JenaSystem;

public class DatasetGraphFactoryEx {
    public static DatasetGraph createInsertOrderPreservingDatasetGraph() {
        return DatasetGraphFactoryEx.createInsertOrderPreservingDatasetGraph(false, false);
    }

    public static DatasetGraph createInsertOrderPreservingDatasetGraph(boolean strictOrderOnQuads, boolean strictOrderOnTriples) {
        Supplier<TripleTableCore> tripleTableSupplier = strictOrderOnTriples ? () -> new TripleTableWithInsertOrderPreservation(new TripleTableCoreFromNestedMapsImpl()) : () -> new TripleTableCoreFromNestedMapsImpl();
        QuadTableCore quadTable = new QuadTableCoreFromMapOfTripleTable(tripleTableSupplier);
        if (strictOrderOnQuads) {
            quadTable = new QuadTableWithInsertOrderPreservation(quadTable);
        }
        StorageRDF storage = StorageRDFBasic.createWithQuadsOnly(quadTable);
        DatasetGraphStorage result = new DatasetGraphStorage(storage, (StoragePrefixes)new StoragePrefixesSimpleMem(), (Transactional)TransactionalLock.createMRSW());
        return result;
    }

    static {
        JenaSystem.init();
    }
}

