/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.dboe;

import java.util.stream.Stream;
import org.aksw.jena_sparql_api.dboe.QuadTableCore;
import org.aksw.jena_sparql_api.dboe.TripleTableCore;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Quad;

public class TripleTableCoreFromQuadTable
implements TripleTableCore {
    protected QuadTableCore quadTable;
    protected Node graphNode;

    public TripleTableCoreFromQuadTable(QuadTableCore quadTable, Node graphNode) {
        this.quadTable = quadTable;
        this.graphNode = graphNode;
    }

    @Override
    public void clear() {
        this.quadTable.deleteGraph(this.graphNode);
    }

    @Override
    public void add(Triple triple) {
        this.quadTable.add(Quad.create((Node)this.graphNode, (Triple)triple));
    }

    @Override
    public void delete(Triple triple) {
        this.quadTable.delete(Quad.create((Node)this.graphNode, (Triple)triple));
    }

    @Override
    public Stream<Triple> find(Node s, Node p, Node o) {
        return this.quadTable.find(this.graphNode, s, p, o).map(Quad::asTriple);
    }
}

